% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvt_id.R
\name{cvt_id}
\alias{cvt_id}
\title{Converting gene ids using annotation databases}
\usage{
cvt_id(db, data, from.id, to.id, desc = FALSE, other = NULL)
}
\arguments{
\item{db}{A character of the annotation database name such as \code{'org.Hs.eg.db'}.}

\item{data}{A \code{data.frame} containing the gene ids in rownames to convert from.}

\item{from.id, to.id}{The type of ids to convert from (\code{'ENSEMBL'}, rownames in \code{data}) and to (\code{'SYMBOL'}) (UniProt) respectively.}

\item{desc}{Logical. If \code{TRUE}, the description of each gene will be included.}

\item{other}{Other information to be added, such as `c('ENZYME', 'PATH')`. See `columns(org.Hs.eg.db)`.}
}
\value{
A \code{data.frame}.
}
\description{
This function is designed to convert one type of gene ids to another type, such as Ensembl, Entrez, UniProt.
}
\examples{
library(org.Hs.eg.db)
# Human Ensembl gene ids are rownames in the data frame.
data <- data.frame(tissue1=10:12, tissue2=20:22, row.names=c('ENSG00000006047', 
'ENSG00000268433', 'ENSG00000268555'))
data <- cvt_id(db='org.Hs.eg.db', data=data, from.id='ENSEMBL', to.id='SYMBOL', desc=TRUE)
data
}
\references{
Pagès H, Carlson M, Falcon S, Li N (2022). _AnnotationDbi: Manipulation of SQLite-based annotations in Bioconductor_. R package version 1.60.0, <https://bioconductor.org/packages/AnnotationDbi>.
Morgan M, Obenchain V, Hester J, Pagès H (2022). SummarizedExperiment: SummarizedExperiment container. R package version 1.28.  0, <https://bioconductor.org/packages/SummarizedExperiment>.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
