% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparrowResult-methods.R
\name{geneSetsStats}
\alias{geneSetsStats}
\title{Summarizes useful statistics per gene set from a SparrowResult}
\usage{
geneSetsStats(
  x,
  feature.min.logFC = 1,
  feature.max.padj = 0.1,
  trim = 0.1,
  reannotate.significance = FALSE,
  as.dt = FALSE
)
}
\arguments{
\item{x}{A \code{SparrowResult} object}

\item{feature.min.logFC}{used with \code{feature.max.padj} to identify
the individual features that are to be considered differentially
expressed.}

\item{feature.max.padj}{used with \code{feature.min.logFC} to identify
the individual features that are to be considered differentially
expressed.}

\item{trim}{The amount to trim when calculated trimmed \code{t} and
\code{logFC} statistics for each geneset.}

\item{reannotate.significance}{this is internally by the package, and should
left as \code{FALSE} when used by the user.}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}
}
\value{
A data.table with statistics at the gene set level across the
prescribed contrast run on \code{x}. These statistics are independent
of any particular GSEA method, but rather summarize aggregate shifts
of the gene sets individual features. The columns included in the output
are summarized below:
\itemize{
\item \code{n.sig}: The number of individual features whose \code{abs(logFC)} and padj
thersholds satisfy the criteria of the \code{feature.min.logFC} and
\code{feature.max.padj} parameters of the original \code{\link[=seas]{seas()}} call
\item \code{n.neutral}: The number of individual features whose abs(logFC) and padj
thersholds do not satisfy the \verb{feature.*} criteria named above.
\item \verb{n.up, n.down}: The number of individual features with \code{logFC > 0} or
\code{logFC < 0}, respectively, irrespective of the \verb{feature.*} thresholds
referenced above.
\item \verb{n.sig.up, n.sig.down}: The number of individual features that pass the
\verb{feature.*} thresholds and have logFC > 0 or logFC < 0, respectively.
\item \verb{mean.logFC, mean.logFC.trim}: The mean (or trimmed mean) of the individual
logFC estimates for the features in the gene set. The amount of trim is
specified in the \code{trim} parameter of the \code{\link[=seas]{seas()}} call.
\item \verb{mean.t, mean.t.trim}: The mean (or trimmed mean) of the individual
t-statistics for the features in the gene sets. These are \code{NA} if the input
expression object was a \code{DGEList}.
}
}
\description{
This function calculates the number of genes that move up/down for the
given contrasts, as well as mean and trimmed mean of the logFC and
t-statistics. Note that the statistics calculated and returned here are
purely a function of the statistics generated at the gene-level stage
of the analysis.
}
\examples{
vm <- exampleExpressionSet(do.voom=TRUE)
gdb <- exampleGeneSetDb()
mg <- seas(vm, gdb, design = vm$design, contrast = 'tumor')
head(geneSetsStats(mg))
}
