% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{package}
\name{spacexr-package}
\alias{spacexr-package}
\alias{spacexr}
\title{spacexr: Cell Type Identification in Spatial Transcriptomics}
\description{
Spatial-eXpression-R (spacexr) is a package for analyzing cell types in spatial transcriptomics data. This implementation is a fork of the spacexr GitHub repo (https://github.com/dmcable/spacexr), adapted to work with Bioconductor objects. The original package implements two statistical methods: RCTD for learning cell types and CSIDE for inferring cell type-specific differential expression. Currently, this fork only implements RCTD, which learns cell type profiles from annotated RNA sequencing (RNA-seq) reference data and uses these profiles to identify cell types in spatial transcriptomic pixels while accounting for platform-specific effects. Future releases will include an implementation of CSIDE.
}
\section{Running RCTD}{


  To get started, create a \code{\link[SpatialExperiment]{SpatialExperiment}}
  object (called \code{spatial} here) for the spatial transcriptomics data
  and a \code{\link[SummarizedExperiment]{SummarizedExperiment}} object
  (called \code{reference} here) for the RNA-seq data. Then simply run RCTD
  as:

  \code{rctd_data <- createRctd(spatial, reference)}

  \code{results <- runRctd(rctd_data)}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ggrajeda/spacexr}
  \item Report bugs at \url{https://github.com/ggrajeda/spacexr/issues}
}

}
\author{
\strong{Maintainer}: Gabriel Grajeda \email{gabriel.grajeda@gmail.com} (\href{https://orcid.org/0009-0003-7242-7476}{ORCID})

Authors:
\itemize{
  \item Dylan Cable \email{dmcable@umich.edu}
}

Other contributors:
\itemize{
  \item Fannie and John Hertz Foundation [funder]
}

}
