% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_beads.R
\name{fitPixels}
\alias{fitPixels}
\title{Runs the RCTD algorithm}
\usage{
fitPixels(RCTD, rctd_mode)
}
\arguments{
\item{RCTD}{an \code{\linkS4class{RctdConfig}} object after running the
\code{\link{chooseSigmaC}} function.}

\item{rctd_mode}{\code{character string}, either "doublet", "multi", or
"full" on which mode to run RCTD. Please see above description.}
}
\value{
a \code{SpatialExperiment} object containing the results of the RCTD
  algorithm.
}
\description{
If in doublet mode, fits at most two cell types per pixel. It classifies each
pixel as 'singlet' or 'doublet' and searches for the cell types on the pixel.
If in full mode, can fit any number of cell types on each pixel. In multi
mode, cell types are added using a greedy algorithm, up to a fixed number.
}
\examples{
data(rctdSim)

# Spatial transcriptomics data
library(SpatialExperiment)
spatial_spe <- SpatialExperiment(
    assay = rctdSim$spatial_rna_counts,
    spatialCoords = rctdSim$spatial_rna_coords
)

# Reference data
library(SummarizedExperiment)
reference_se <- SummarizedExperiment(
    assays = list(counts = rctdSim$reference_counts),
    colData = rctdSim$reference_cell_types
)

# Create RCTD configuration
rctd_data <- createRctd(spatial_spe, reference_se)
rctd <- createRctdConfig(rctd_data)
rctd <- fitBulk(rctd)
rctd <- chooseSigmaC(rctd)
results <- fitPixels(rctd, rctd_mode = "doublet")

}
\keyword{internal}
