% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing.R
\name{create_spe_from_columns}
\alias{create_spe_from_columns}
\title{Converts a list of RCTD results to a \code{SpatialExperiment}}
\usage{
create_spe_from_columns(
  RCTD,
  results,
  weights_col = "all_weights",
  character_cols = c(),
  logical_cols = c(),
  numeric_cols = c(),
  list_cols = c()
)
}
\arguments{
\item{RCTD}{RctdConfig object}

\item{results}{List of results (with named entries) for each pixel}

\item{weights_col}{Name of list entry containing the cell type weights}

\item{character_cols}{Names of list entries containing a character(1)}

\item{logical_cols}{Names of list entries containing a logical(1)}

\item{numeric_cols}{Names of list entries containing a numeric(1)}

\item{list_cols}{Names of list entries containing a list}
}
\value{
\code{SpatialExperiment} containing RCTD results
}
\description{
The \code{SpatialExperiment} contains an assay with the cell type weights.
Additional information (e.g., classification confidence) is stored in the
\code{colData}, which contains the entries in the results list specified by
the *_cols arguments. Spatial coordinates are stored in the
\code{spatialCoords}.
}
\keyword{internal}
