% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spARI.R
\name{spARI}
\alias{spARI}
\title{The function spARI is the main function to calculate spRI and spARI values proposed
    in the paper.}
\usage{
spARI(
  r_labels,
  c_labels,
  coords = NULL,
  dist_mat = NULL,
  f_func_input = NULL,
  h_func_input = NULL,
  alpha_val = 0.8,
  spe = NULL
)
}
\arguments{
\item{r_labels}{Annotated labels of all spots/cells. Can be numeric vector or character vector.}

\item{c_labels}{Estimated labels obtained by a certain spatial clustering method.}

\item{coords}{Spatial coordinates (2 columns). 1st column: first dimension coordinate.
2nd column: second dimension coordinate. Default is NULL.}

\item{dist_mat}{Distance matrix provided by users. If both coords and dist_mat
are provided, we will directly use the distance matrix. Default is NULL.
Please notice that if dist_mat is sparse, the weight function for object pairs without recorded distances
degenerates to the setting used in the classical Rand index.}

\item{f_func_input}{R function; function f provided by users.}

\item{h_func_input}{R function; function h provided by users.}

\item{alpha_val}{Parameter in the default functions f and h, which belongs to the open interval (0, 1)
to keep a positive gap between the maximal weight of the disagreement pair and the weight one of the agreement pair.
Default is 0.8.}

\item{spe}{SpatialExperiment object; stores various components of spatial transcriptomics data, including
spatialCoords: A matrix containing the spatial coordinates;
colData$cell_type: Annotated cell type labels for each spot or cell;
colData$cluster: Clustering labels for each spot or cell.
Default is NULL.}
}
\value{
spARI returns an R numeric including the following information.
\item{spRI_value}{numeric, the spRI value calculated by r_labels and c_labels}
\item{spARI_value}{numeric, the spARI value calculated by r_labels and c_labels}
}
\description{
The function spARI is the main function to calculate spRI and spARI values proposed
    in the paper.
}
\examples{
library(spARI)
### --- Import example data --- ###
# (1) true_labels: ground truth of 160 spots (input as r_labels)
# (2) c1_labels: one partition results of these spots (input as c_labels)
# (3) c2_labels: another partition results of these spots (input as c_labels)
# (4) coords: spatial coordinates of these spots (2 columns)
data(spARI_example_data)
true_labels = spARI_example_data$true_labels
c1_labels = spARI_example_data$c1_labels
c2_labels = spARI_example_data$c2_labels
coords = spARI_example_data$coords
### --- Compute spRI and spARI --- ###
res1 = spARI(r_labels=true_labels, c_labels=c1_labels, coords=coords)
res2 = spARI(r_labels=true_labels, c_labels=c2_labels, coords=coords)
cat(paste0("1st: spRI=", round(res1[1], 3), ", spARI=", round(res1[2], 3), "\n"))
cat(paste0("2nd: spRI=", round(res2[1], 3), ", spARI=", round(res2[2], 3), "\n"))

}
