% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWindowDistPI.R
\name{calcWindowDistPI}
\alias{calcWindowDistPI}
\title{Estimate the PI for the distance to a fixed object of interest, such as a cell wall or centroid}
\usage{
calcWindowDistPI(pSub, owins, centroids, ecdfAll, pi)
}
\arguments{
\item{pSub}{The subset point pattern containing only a single gene}

\item{owins, centroids}{The list of windows corresponding to cells,
and their centroids}

\item{ecdfAll}{the cumulative distribution function under the null}

\item{pi}{The type of PI to calculate}
}
\value{
A list of vectors of estimated probabilistic indeces per event
}
\description{
Estimate the PI for the distance to a fixed object of interest, such as a cell wall or centroid
}
\details{
Analysis of the distance to the border was introduced by \insertCite{Joyner2013}{smoppix} in the form of the B-function.
The independent evaluations of the B-functions under the null hypothesis represented by \emph{ecdfAll} 
per cell are here returned as realizations of the probabilistic index.
}
\references{
\insertAllCited{}
}
\seealso{
\link{addCell}, \link{estPis}
}
