% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcIndividualPIs.R
\name{calcIndividualPIs}
\alias{calcIndividualPIs}
\title{Calculate individual PI entries of a single point pattern}
\usage{
calcIndividualPIs(
  p,
  tabObs,
  pis,
  pSubLeft,
  owins,
  centroids,
  null,
  features,
  ecdfAll,
  ecdfsCell,
  loopFun,
  minDiff,
  minObsNN
)
}
\arguments{
\item{p}{The point pattern}

\item{tabObs}{A table of observed gene frequencies}

\item{pis}{The PIs to be estimated or for which weighting functions is to be added}

\item{pSubLeft}{The subsampled overall point pattern returned by subSampleP}

\item{owins, centroids}{The list of windows corresponding to cells,
and their centroids}

\item{null}{A character vector, indicating how the null distribution is
defined. See details.}

\item{features}{A character vector, for which features should the
probabilistic indices be calculated?}

\item{ecdfAll, ecdfsCell}{Empirical cumulative distribution functions of all
events and of cells within the cell, under the null}

\item{loopFun}{The function to use to loop over the features.
Defaults to bplapply except when looping over features within cells}

\item{minDiff}{An integer, the minimum number of events from other genes
needed for calculation of background distribution of distances.
Matters mainly for within-cell calculations: cells with too few events are skipped.}

\item{minObsNN}{An integer, the minimum number of events required for a gene to be analysed. See details.}
}
\value{
A list containing PI entries per feature
}
\description{
Calculate individual PI entries of a single point pattern
}
\details{
For the single-feature nearest neighbour distances, the PI is average
over the point pattern
}
\seealso{
\link{estPis}, \link{calcNNPI}
}
