% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_markers.R
\name{top_markers_abs}
\alias{top_markers_abs}
\title{calculate group median, MAD or mean score and order genes based on scores}
\usage{
top_markers_abs(
  data,
  label,
  n = 10,
  pooled.sd = FALSE,
  method = c("median", "mad", "mean"),
  scale = TRUE,
  use.mgm = TRUE,
  softmax = TRUE,
  tau = 1
)
}
\arguments{
\item{data}{matrix, features in row and samples in column}

\item{label}{a vector of group label}

\item{n}{integer, number of returned top genes for each group}

\item{pooled.sd}{logical, if to use pooled SD for scaling}

\item{method}{character, specify metric to compute, can be one of "median",
"mad", "mean"}

\item{scale}{logical, if to scale data by row}

\item{use.mgm}{logical, if to scale data using \code{\link[=scale_mgm]{scale_mgm()}}}

\item{softmax}{logical, if to apply softmax transformation on output}

\item{tau}{numeric, hyper parameter for softmax}
}
\value{
a tibble with feature names, group labels and ordered processed scores
}
\description{
calculate group median, MAD or mean score and order genes based on scores
}
\examples{
data <- matrix(rgamma(100, 2), 10, dimnames = list(1:10))
top_markers_abs(data, label = rep(c("A", "B"), 5))
}
