% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{pairs-SlingshotDataSet}
\alias{pairs-SlingshotDataSet}
\alias{pairs.SlingshotDataSet}
\title{Pairs plot of Slingshot output}
\usage{
\method{pairs}{SlingshotDataSet}(
  x,
  type = NULL,
  show.constraints = FALSE,
  col = NULL,
  pch = 16,
  cex = 1,
  lwd = 2,
  ...,
  labels,
  horInd = seq_len(nc),
  verInd = seq_len(nc),
  lower.panel = FALSE,
  upper.panel = TRUE,
  diag.panel = NULL,
  text.panel = textPanel,
  label.pos = 0.5 + has.diag/3,
  line.main = 3,
  cex.labels = NULL,
  font.labels = 1,
  row1attop = TRUE,
  gap = 1
)
}
\arguments{
\item{x}{a \code{SlingshotDataSet} with results to be plotted.}

\item{type}{character, the type of output to be plotted, can be one of
\code{"lineages"}, \code{curves}, or \code{both} (by partial matching), see
Details for more.}

\item{show.constraints}{logical, whether or not the user-specified initial
and terminal clusters should be specially denoted by green and red dots,
respectively.}

\item{col}{character, color vector for points.}

\item{pch}{integer or character specifying the plotting symbol, see
\code{\link{par}}.}

\item{cex}{numeric, amount by which points should be magnified, see
\code{\link{par}}.}

\item{lwd}{numeric, the line width, see \code{\link{par}}.}

\item{...}{additional parameters for \code{plot} or \code{axis}, see
\code{\link[graphics]{pairs}}.}

\item{labels}{character, the names of the variables, see
\code{\link[graphics]{pairs}}.}

\item{horInd}{see \code{\link[graphics]{pairs}}.}

\item{verInd}{see \code{\link[graphics]{pairs}}.}

\item{lower.panel}{see \code{\link[graphics]{pairs}}.}

\item{upper.panel}{see \code{\link[graphics]{pairs}}.}

\item{diag.panel}{see \code{\link[graphics]{pairs}}.}

\item{text.panel}{see \code{\link[graphics]{pairs}}.}

\item{label.pos}{see \code{\link[graphics]{pairs}}.}

\item{line.main}{see \code{\link[graphics]{pairs}}.}

\item{cex.labels}{see \code{\link[graphics]{pairs}}.}

\item{font.labels}{see \code{\link[graphics]{pairs}}.}

\item{row1attop}{see \code{\link[graphics]{pairs}}.}

\item{gap}{see \code{\link[graphics]{pairs}}.}
}
\value{
returns \code{NULL}.
}
\description{
A tool for quickly visualizing lineages inferred by
  \code{slingshot}.
}
\details{
If \code{type == 'lineages'}, straight line connectors between
  cluster centers will be plotted. If \code{type == 'curves'}, simultaneous
  principal curves will be plotted.

When \code{type} is not specified, the function will first check the
  \code{curves} slot and plot the curves, if present. Otherwise,
  \code{lineages} will be plotted, if present.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = "1")
pairs(SlingshotDataSet(pto))

}
