% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\name{SlingshotDataSet}
\alias{SlingshotDataSet}
\alias{SlingshotDataSet,SingleCellExperiment-method}
\alias{SlingshotDataSet,SlingshotDataSet-method}
\alias{SlingshotDataSet,PseudotimeOrdering-method}
\title{Extract Slingshot output}
\usage{
SlingshotDataSet(data, ...)

\S4method{SlingshotDataSet}{SingleCellExperiment}(data)

\S4method{SlingshotDataSet}{SlingshotDataSet}(data)

\S4method{SlingshotDataSet}{PseudotimeOrdering}(data)
}
\arguments{
\item{data}{an object containing \code{slingshot} output.}

\item{...}{additional arguments to pass to object-specific methods.}
}
\value{
A \code{SlingshotDataSet} object containing the output of
\code{slingshot}.
}
\description{
This is a convenience function to extract a
  \code{SlingshotDataSet} from an object containing \code{\link{slingshot}}
  output. However, we now recommend using a
  \code{\link[TrajectoryUtils]{PseudotimeOrdering}} object, in most cases.
  The \code{SlingshotDataSet} is, however, still used for plotting purposes.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
library(SingleCellExperiment)
u <- matrix(rpois(140*50, 5), nrow = 50)
sce <- SingleCellExperiment(assays = list(counts = u), 
                            reducedDims = SimpleList(PCA = rd),
                            colData = data.frame(clus = cl))
sce <- slingshot(sce, clusterLabels = 'clus', reducedDim = 'PCA')
SlingshotDataSet(sce)

}
\seealso{
\code{\link[TrajectoryUtils]{PseudotimeOrdering}},
  \code{\link{as.SlingshotDataSet}}
}
