% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.phyMSAmatched}
\alias{plot.phyMSAmatched}
\alias{plot.lineagePath}
\alias{plot.parallelSites}
\alias{plot.fixationSites}
\alias{plot.sitePath}
\alias{plot.fixationIndels}
\alias{plot.fixationPath}
\title{Visualize the results}
\usage{
\method{plot}{phyMSAmatched}(x, y = TRUE, ...)

\method{plot}{lineagePath}(x, y = TRUE, showTips = FALSE, ...)

\method{plot}{parallelSites}(x, y = TRUE, ...)

\method{plot}{fixationSites}(x, y = TRUE, tipsGrouping = NULL, ...)

\method{plot}{sitePath}(x, y = NULL, select = NULL, showTips = FALSE, ...)

\method{plot}{fixationIndels}(x, y = TRUE, ...)

\method{plot}{fixationPath}(x, y = TRUE, ...)
}
\arguments{
\item{x}{The object to plot.}

\item{y}{Whether to show the fixation mutation between clusters. For
\code{lineagePath} object and \code{sitePath} object, it is deprecated and
no longer have effect since 1.5.4.}

\item{...}{Other arguments. Since 1.5.4, the function uses
\code{\link{ggtree}} as the base function to make plots so the arguments in
\code{plot.phylo} will no longer work.}

\item{showTips}{Whether to plot the tip labels. The default is \code{FALSE}.}

\item{tipsGrouping}{A \code{list} to hold the grouping of tips for how the
tree will be colored.}

\item{select}{For a \code{sitePath} object, it can have result on more than
one evolution pathway. This is to select which path to plot. The default is
\code{NULL} which will plot all the paths. It is the same as \code{select}
in \code{\link{plotSingleSite}}.}
}
\value{
A ggplot object to make the plot.
}
\description{
The plot function to visualize the return of functions in the
  package. The underlying function applies \code{\link{ggplot2}}. The
  function name \code{plot} is used to keep the compatibility with previous
  versions, but they do not behave like the generic \code{\link{plot}}
  function since 1.5.4.

A \code{\link{phyMSAmatched}} object will be plotted as a tree
  diagram.

A \code{\link{lineagePath}} object will be plotted as a tree
  diagram and paths are black solid line while the trimmed nodes and tips
  will use gray dashed line.

A \code{\link{parallelSites}} object will be plotted as original
  phylogenetic tree marked with parallel mutations attached as dot plot.

A \code{\link{fixationSites}} object will be plotted as original
  phylogenetic tree marked with fixation substitutions.

A \code{sitePath} object can be extracted by using
  \code{\link{extractSite}} on the return of \code{\link{fixationSites}}.

A \code{\link{fixationIndels}} object will be plotted as
  original phylogenetic tree marked with indel fixation.

A \code{\link{fixationPath}} object will be plotted as a
  \code{phylo} object. The tips are clustered according to the fixation
  sites. The transition of fixation sites will be plotted as a phylogenetic
  tree. The length of each branch represents the number of fixation mutation
  between two clusters.
}
\examples{
data(zikv_tree)
data(zikv_align)
tree <- addMSA(zikv_tree, alignment = zikv_align)
plot(tree)
paths <- lineagePath(tree)
plot(paths)
parallel <- parallelSites(paths)
plot(parallel)
fixations <- fixationSites(paths)
plot(fixations)
sp <- extractSite(fixations, 139)
plot(sp)
x <- fixationPath(fixations)
plot(x)
}
