% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiScoreGeneric.R
\name{multiScore}
\alias{multiScore}
\alias{multiScore,matrix,GeneSetCollection,missing-method}
\alias{multiScore,matrix,GeneSetCollection,GeneSetCollection-method}
\alias{multiScore,matrix,list,missing-method}
\alias{multiScore,matrix,list,list-method}
\title{single-sample gene-set scoring method for multiple signatures}
\usage{
multiScore(
  rankData,
  upSetColc,
  downSetColc,
  subSamples = NULL,
  centerScore = TRUE,
  dispersionFun = mad,
  knownDirection = TRUE
)

\S4method{multiScore}{matrix,GeneSetCollection,missing}(
  rankData,
  upSetColc,
  downSetColc,
  subSamples = NULL,
  centerScore = TRUE,
  dispersionFun = mad,
  knownDirection = TRUE
)

\S4method{multiScore}{matrix,GeneSetCollection,GeneSetCollection}(
  rankData,
  upSetColc,
  downSetColc,
  subSamples = NULL,
  centerScore = TRUE,
  dispersionFun = mad,
  knownDirection = TRUE
)

\S4method{multiScore}{matrix,list,missing}(
  rankData,
  upSetColc,
  downSetColc,
  subSamples = NULL,
  centerScore = TRUE,
  dispersionFun = mad,
  knownDirection = TRUE
)

\S4method{multiScore}{matrix,list,list}(
  rankData,
  upSetColc,
  downSetColc,
  subSamples = NULL,
  centerScore = TRUE,
  dispersionFun = mad,
  knownDirection = TRUE
)
}
\arguments{
\item{rankData}{A matrix object, ranked gene expression matrix data generated
using the \code{\link[=rankGenes]{rankGenes()}} function (make sure this matrix is not modified, see
details)}

\item{upSetColc}{A GeneSetCollection object, a list of GeneSet objects, or a
list of character vectors of up-regulated (or mixed, see
\code{\link{simpleScore}}) gene sets.}

\item{downSetColc}{A GeneSetCollection object, a list of GeneSet objects, or a
list of character vectors of down-regulated gene sets. NULL otherwise. Names
of gene sets within this collection/list should be the same as those of the
upSetColc}

\item{subSamples}{A vector of sample labels/indices that will be used to
subset the rankData matrix. All samples will be scored if not provided}

\item{centerScore}{A Boolean, specifying whether scores should be centered
around 0, default as TRUE. Note: scores never centered if \code{knownDirection = FALSE}}

\item{dispersionFun}{A function, dispersion function with default being \code{mad}}

\item{knownDirection}{A boolean, determining whether the gene set should be
considered to be directional or not. A gene set is directional if the type
of genes in it are known i.e. up- or down-regulated. This should be set to
TRUE if the gene set is composed of both up- AND down-regulated genes.
Defaults to TRUE. This parameter becomes irrelevant when both upSet(Colc)
and downSet(Colc) are provided.}
}
\value{
A list of two matrices containing the scores and dispersions
}
\description{
This function computes 'singscores' using a ranked gene
expression matrix obtained from the \code{\link[=rankGenes]{rankGenes()}} function and a
GeneSetCollection object or a list of GeneSet objects. It returns a list of
two matrices containing the scores and dispersions. This function should be
used when scoring needs to be performed for multiple signatures. It is
faster than applying \code{\link[=simpleScore]{simpleScore()}} across the different signatures
independently.
}
\examples{
ranked <- rankGenes(toy_expr_se)
GSEABase::setName(toy_gs_up)  = "toy_gs_up"
GSEABase::setName(toy_gs_dn)  = "toy_gs_dn"
gslist <- list(toy_gs_up, toy_gs_dn)

gscolc <- GSEABase::GeneSetCollection(gslist)
scoredf <- multiScore(ranked, upSetColc = gscolc)
}
\seealso{
\code{\link{rank}} \code{"\linkS4class{GeneSet}"}
}
