% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratUMAP}
\alias{runSeuratUMAP}
\title{runSeuratUMAP
Computes UMAP from the given sce object and stores the UMAP computations back
into the sce object}
\usage{
runSeuratUMAP(
  inSCE,
  useReduction = c("pca", "ica"),
  reducedDimName = "seuratUMAP",
  dims = 10,
  minDist = 0.3,
  nNeighbors = 30L,
  spread = 1,
  externalReduction = NULL,
  seed = 42,
  verbose = TRUE
)
}
\arguments{
\item{inSCE}{(sce) object on which to compute the UMAP}

\item{useReduction}{Reduction to use for computing UMAP. One of "pca" or
"ica". Default is \code{"pca"}.}

\item{reducedDimName}{Name of new reducedDims object containing Seurat UMAP
Default \code{seuratUMAP}.}

\item{dims}{Numerical value of how many reduction components to use for UMAP
computation. Default \code{10}.}

\item{minDist}{Sets the \code{"min.dist"} parameter to the underlying UMAP
call. See \link[Seurat]{RunUMAP} for more information. Default \code{0.3}.}

\item{nNeighbors}{Sets the \code{"n.neighbors"} parameter to the underlying
UMAP call. See \link[Seurat]{RunUMAP} for more information. Default
\code{30L}.}

\item{spread}{Sets the \code{"spread"} parameter to the underlying UMAP call.
See \link[Seurat]{RunUMAP} for more information. Default \code{1}.}

\item{externalReduction}{Pass DimReduc object if PCA/ICA computed through
other libraries. Default \code{NULL}.}

\item{seed}{Random seed for reproducibility of results.
Default \code{42}.}

\item{verbose}{Logical value indicating if informative messages should
be displayed. Default is \code{TRUE}.}
}
\value{
Updated sce object with UMAP computations stored
}
\description{
runSeuratUMAP
Computes UMAP from the given sce object and stores the UMAP computations back
into the sce object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runSeuratNormalizeData(sce, useAssay = "counts")
sce <- runSeuratFindHVG(sce, useAssay = "counts")
sce <- runSeuratScaleData(sce, useAssay = "counts")
sce <- runSeuratPCA(sce, useAssay = "counts")
sce <- runSeuratFindClusters(sce, useAssay = "counts")
sce <- runSeuratUMAP(sce, useReduction = "pca")
}
}
