% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{runScanpyScaleData}
\alias{runScanpyScaleData}
\title{runScanpyScaleData
Scales the input sce object according to the input parameters}
\usage{
runScanpyScaleData(
  inSCE,
  useAssay = "scanpyNormData",
  scaledAssayName = "scanpyScaledData"
)
}
\arguments{
\item{inSCE}{(sce) object to scale}

\item{useAssay}{Assay containing normalized counts to scale.}

\item{scaledAssayName}{Name of new assay containing scaled data. Default
\code{scanpyScaledData}.}
}
\value{
Scaled \code{SingleCellExperiment} object
}
\description{
runScanpyScaleData
Scales the input sce object according to the input parameters
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
}
}
