% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFindMarker.R
\name{runFindMarker}
\alias{runFindMarker}
\alias{findMarkerDiffExp}
\title{Find the marker gene set for each cluster}
\usage{
runFindMarker(
  inSCE,
  useAssay = "logcounts",
  useReducedDim = NULL,
  method = "wilcox",
  cluster = "cluster",
  covariates = NULL,
  log2fcThreshold = NULL,
  fdrThreshold = 0.05,
  minClustExprPerc = NULL,
  maxCtrlExprPerc = NULL,
  minMeanExpr = NULL,
  detectThresh = 0
)

findMarkerDiffExp(
  inSCE,
  useAssay = "logcounts",
  useReducedDim = NULL,
  method = c("wilcox", "MAST", "DESeq2", "Limma", "ANOVA"),
  cluster = "cluster",
  covariates = NULL,
  log2fcThreshold = NULL,
  fdrThreshold = 0.05,
  minClustExprPerc = NULL,
  maxCtrlExprPerc = NULL,
  minMeanExpr = NULL,
  detectThresh = 0
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{useAssay}{character. A string specifying which assay to use for the
MAST calculations. Default \code{"logcounts"}.}

\item{useReducedDim}{character. A string specifying which reducedDim to use
for MAST calculations. Set \code{useAssay} to \code{NULL} when using.
Required.}

\item{method}{A single character for specific differential expression
analysis method. Choose from \code{'wilcox'}, \code{'MAST'}, \code{'DESeq2'},
\code{'Limma'}, and \code{'ANOVA'}. Default \code{"wilcox"}.}

\item{cluster}{One single character to specify a column in
\code{colData(inSCE)} for the clustering label. Alternatively, a vector or
a factor is also acceptable. Default \code{"cluster"}.}

\item{covariates}{A character vector of additional covariates to use when
building the model. All covariates must exist in
\code{names(colData(inSCE))}. Not applicable when \code{method} is
\code{"MAST"} method. Default \code{NULL}.}

\item{log2fcThreshold}{Only out put DEGs with the absolute values of log2FC
larger than this value. Default \code{NULL}}

\item{fdrThreshold}{Only out put DEGs with FDR value smaller than this
value. Default \code{NULL}}

\item{minClustExprPerc}{A numeric scalar. The minimum cutoff of the
percentage of cells in the cluster of interests that expressed the marker
gene. From 0 to 1. Default \code{NULL}.}

\item{maxCtrlExprPerc}{A numeric scalar. The maximum cutoff of the
percentage of cells out of the cluster (control group) that expressed the
marker gene. From 0 to 1. Default \code{NULL}.}

\item{minMeanExpr}{A numeric scalar. The minimum cutoff of the mean
expression value of the marker in the cluster of interests. Default
\code{NULL}.}

\item{detectThresh}{A numeric scalar, above which a matrix value will be
treated as expressed when calculating cluster/control expression percentage.
Default \code{0}.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{metadata(inSCE)$findMarker} updated with a data.table of the up-
regulated DEGs for each cluster.
}
\description{
With an input SingleCellExperiment object and specifying the
clustering labels, this function iteratively call the differential expression
analysis on each cluster against all the others. \code{\link{runFindMarker}}
will be deprecated in the future.
}
\details{
The returned marker table, in the \code{metadata} slot, consists of 8
columns: \code{"Gene"}, \code{"Log2_FC"}, \code{"Pvalue"}, \code{"FDR"},
\code{cluster}, \code{"clusterExprPerc"}, \code{"ControlExprPerc"} and
\code{"clusterAveExpr"}.

\code{"clusterExprPerc"} is the fraction of cells,
that has marker value (e.g. gene expression counts) larger than
\code{detectThresh}, in the cell population of the cluster. As for each
cluster, we set all cells out of this cluster as control. Similarly,
\code{"ControlExprPerc"} is the fraction of cells with marker value larger
than \code{detectThresh} in the control cell group.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runFindMarker(mouseBrainSubsetSCE,
                                     useAssay = "logcounts",
                                     cluster = "level1class")
}
\seealso{
\code{\link{runDEAnalysis}}, \code{\link{getFindMarkerTopTable}},
\code{\link{plotFindMarkerHeatmap}}
}
