% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubletFinder_doubletDetection.R
\name{runDoubletFinder}
\alias{runDoubletFinder}
\title{Generates a doublet score for each cell via doubletFinder}
\usage{
runDoubletFinder(
  inSCE,
  sample = NULL,
  useAssay = "counts",
  seed = 12345,
  seuratNfeatures = 2000,
  seuratPcs = seq(15),
  seuratRes = 1.5,
  sct = FALSE,
  formationRate = 0.075,
  nCores = NULL,
  verbose = FALSE
)
}
\arguments{
\item{inSCE}{inSCE A \linkS4class{SingleCellExperiment} object.}

\item{sample}{Character vector or colData variable name. Indicates which 
sample each cell belongs to. Default \code{NULL}.}

\item{useAssay}{A string specifying which assay in the SCE to use. Default 
\code{"counts"}.}

\item{seed}{Seed for the random number generator, can be set to \code{NULL}. 
Default \code{12345}.}

\item{seuratNfeatures}{Integer. Number of highly variable genes to use.
Default \code{2000}.}

\item{seuratPcs}{Numeric vector. The PCs used in seurat function to
determine number of clusters. Default \code{1:15}.}

\item{seuratRes}{Numeric vector. The resolution parameter used in Seurat,
which adjusts the number of clusters determined via the algorithm. Default 
\code{1.5}.}

\item{sct}{Whether or not to use SCT. Default \code{FALSE}.}

\item{formationRate}{Doublet formation rate used within algorithm. Default 
\code{0.075}.}

\item{nCores}{Number of cores used for running the function. Default 
\code{NULL}.}

\item{verbose}{Boolean. Wheter to print messages from Seurat and 
DoubletFinder. Default \code{FALSE}.}
}
\value{
\linkS4class{SingleCellExperiment} object containing the
\code{doublet_finder_doublet_score} variable in \code{colData} slot.
}
\description{
Uses doubletFinder to determine cells within the dataset
 suspected to be doublets.
}
\examples{
data(scExample, package = "singleCellTK")
options(future.globals.maxSize = 786432000)
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runDoubletFinder(sce)
}
\seealso{
\code{\link{runCellQC}}, \code{\link{plotDoubletFinderResults}}
}
