% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDimReduce.R
\name{runDimReduce}
\alias{runDimReduce}
\title{Generic Wrapper function for running dimensionality reduction}
\usage{
runDimReduce(
  inSCE,
  method = c("scaterPCA", "seuratPCA", "seuratICA", "scanpyPCA", "rTSNE", "seuratTSNE",
    "scaterUMAP", "seuratUMAP", "scanpyUMAP", "scanpyTSNE"),
  useAssay = NULL,
  useReducedDim = NULL,
  useAltExp = NULL,
  reducedDimName = method,
  nComponents = 20,
  useFeatureSubset = NULL,
  scale = FALSE,
  seed = 12345,
  ...
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{method}{One from \code{"scaterPCA"}, \code{"seuratPCA"},
\code{"seuratICA"}, \code{"rTSNE"}, \code{"seuratTSNE"}, \code{"scaterUMAP"},
\code{"seuratUMAP"}, \code{"scanpyPCA"}, \code{"scanpyUMAP"} and \code{"scanpyTSNE"}.}

\item{useAssay}{Assay to use for computation. If \code{useAltExp} is
specified, \code{useAssay} has to exist in
\code{assays(altExp(inSCE, useAltExp))}. Default \code{"counts"}.}

\item{useReducedDim}{The low dimension representation to use for embedding
computation. Default \code{NULL}.}

\item{useAltExp}{The subset to use for computation, usually for the
selected variable features. Default \code{NULL}.}

\item{reducedDimName}{The name of the result matrix. Required.}

\item{nComponents}{Specify the number of dimensions to compute with the
selected method in case of PCA/ICA and the number of components to
use in the case of TSNE/UMAP methods.}

\item{useFeatureSubset}{Subset of feature to use for dimension reduction. A
character string indicating a \code{rowData} variable that stores the logical
vector of HVG selection, or a vector that can subset the rows of
\code{inSCE}. Default \code{NULL}.}

\item{scale}{Logical scalar, whether to standardize the expression values.
Default \code{TRUE}.}

\item{seed}{Random seed for reproducibility of results.
Default \code{NULL} will use global seed in use by the R environment.}

\item{...}{The other arguments for running a specific algorithm. Please refer
to the one you use.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{reducedDim} updated with the result.
}
\description{
Generic Wrapper function for running dimensionality reduction
}
\details{
Wrapper function to run one of the available dimensionality
reduction algorithms integrated within SCTK from \code{\link{scaterPCA}},
\code{\link{runSeuratPCA}}, \code{\link{runSeuratICA}}, \code{\link{runTSNE}},
\code{\link{runSeuratTSNE}}, \code{\link{runUMAP}} and
\code{\link{runSeuratUMAP}}. Users can use an assay by specifying
\code{useAssay}, use the assay in an altExp by specifying both
\code{useAltExp} and \code{useAssay}, or use a low-dimensionality
representation by specifying \code{useReducedDim}.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runNormalization(sce, useAssay = "counts",
                        outAssayName = "logcounts",
                        normalizationMethod = "logNormCounts")
sce <- runDimReduce(inSCE = sce, method = "scaterPCA",
                    useAssay = "logcounts", scale = TRUE,
                    reducedDimName = "PCA")
}
