% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyMatrixPlot}
\alias{plotScanpyMatrixPlot}
\title{plotScanpyMatrixPlot}
\usage{
plotScanpyMatrixPlot(
  inSCE,
  useAssay = NULL,
  features,
  groupBy,
  standardScale = NULL,
  title = "",
  vmin = NULL,
  vmax = NULL,
  colorBarTitle = "Mean expression in group"
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{useAssay}{Assay to use for plotting. By default it will use counts assay.}

\item{features}{Genes to plot. Sometimes is useful to pass a specific list of
var names (e.g. genes). The var_names could be a dictionary or a list.}

\item{groupBy}{The key of the observation grouping to consider.}

\item{standardScale}{Whether or not to standardize the given dimension 
between 0 and 1, meaning for each variable or group, subtract the minimum and 
divide each by its maximum. Default \code{NULL} means that it doesn't perform
any scaling.}

\item{title}{Provide title for the figure.}

\item{vmin}{The value representing the lower limit of the color scale. 
Values smaller than vmin are plotted with the same color as vmin. 
Default \code{NULL}}

\item{vmax}{The value representing the upper limit of the color scale. 
Values larger than vmax are plotted with the same color as vmax. 
Default \code{NULL}}

\item{colorBarTitle}{Title for the color bar.}
}
\value{
plot object
}
\description{
plotScanpyMatrixPlot
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyUMAP(sce, useReducedDim = "scanpyPCA")
markers <- c("MALAT1" ,"RPS27" ,"CST3")
plotScanpyMatrixPlot(sce, features = markers, groupBy = 'Scanpy_louvain_1')
}
}
