% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyMarkerGenes}
\alias{plotScanpyMarkerGenes}
\title{plotScanpyMarkerGenes}
\usage{
plotScanpyMarkerGenes(
  inSCE,
  groups = NULL,
  nGenes = 10,
  nCols = 4,
  sharey = FALSE
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{groups}{The groups for which to show the gene ranking. Default \code{NULL}
means that all groups will be considered.}

\item{nGenes}{Number of genes to show. Default \code{10}}

\item{nCols}{Number of panels shown per row. Default \code{4}}

\item{sharey}{Controls if the y-axis of each panels should be shared. 
Default \code{FALSE} allows each panel to have its own y-axis range.}
}
\value{
plot object
}
\description{
plotScanpyMarkerGenes
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyFindMarkers(sce, colDataName = "Scanpy_louvain_1" )
plotScanpyMarkerGenes(sce, groups = '0')
}
}
