% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPlotting.R
\name{plotSCEBarAssayData}
\alias{plotSCEBarAssayData}
\title{Bar plot of assay data.}
\usage{
plotSCEBarAssayData(
  inSCE,
  feature,
  sample = NULL,
  useAssay = "counts",
  featureLocation = NULL,
  featureDisplay = NULL,
  groupBy = NULL,
  xlab = NULL,
  ylab = NULL,
  axisSize = 10,
  axisLabelSize = 10,
  dotSize = 0.1,
  transparency = 1,
  defaultTheme = TRUE,
  gridLine = FALSE,
  summary = NULL,
  title = NULL,
  titleSize = NULL,
  combinePlot = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results. Required.}

\item{feature}{Name of feature stored in assay of SingleCellExperiment
object.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.}

\item{useAssay}{Indicate which assay to use. Default "counts".}

\item{featureLocation}{Indicates which column name of rowData to query gene.}

\item{featureDisplay}{Indicates which column name of rowData to use
to display feature for visualization.}

\item{groupBy}{Groupings for each numeric value. A user may input a vector
equal length to the number of the samples in the SingleCellExperiment
object, or can be retrieved from the colData slot. Default NULL.}

\item{xlab}{Character vector. Label for x-axis. Default NULL.}

\item{ylab}{Character vector. Label for y-axis. Default NULL.}

\item{axisSize}{Size of x/y-axis ticks. Default 10.}

\item{axisLabelSize}{Size of x/y-axis labels. Default 10.}

\item{dotSize}{Size of dots. Default 0.1.}

\item{transparency}{Transparency of the dots, values will be 0-1. Default 1.}

\item{defaultTheme}{Removes grid in plot and sets axis title size to 10
when TRUE. Default TRUE.}

\item{gridLine}{Adds a horizontal grid line if TRUE. Will still be
drawn even if defaultTheme is TRUE. Default FALSE.}

\item{summary}{Adds a summary statistic, as well as a crossbar to the
violin plot. Options are "mean" or "median". Default NULL.}

\item{title}{Title of plot. Default NULL.}

\item{titleSize}{Size of title of plot. Default 15.}

\item{combinePlot}{Boolean. If multiple plots are generated (multiple
samples, etc.), will combined plots using `cowplot::plot_grid`.
Default TRUE.}
}
\value{
a ggplot of the barplot of assay data.
}
\description{
Visualizes values stored in the assay slot of a
 SingleCellExperiment object via a bar plot.
}
\examples{
data("mouseBrainSubsetSCE")
plotSCEBarAssayData(
  inSCE = mouseBrainSubsetSCE,
  feature = "Apoe", groupBy = "sex"
)
}
