% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importOptimus.R
\name{importOptimus}
\alias{importOptimus}
\title{Construct SCE object from Optimus output}
\usage{
importOptimus(
  OptimusDirs,
  samples,
  matrixLocation = "call-MergeCountFiles/sparse_counts.npz",
  colIndexLocation = "call-MergeCountFiles/sparse_counts_col_index.npy",
  rowIndexLocation = "call-MergeCountFiles/sparse_counts_row_index.npy",
  cellMetricsLocation = "call-MergeCellMetrics/merged-cell-metrics.csv.gz",
  geneMetricsLocation = "call-MergeGeneMetrics/merged-gene-metrics.csv.gz",
  emptyDropsLocation = "call-RunEmptyDrops/empty_drops_result.csv",
  class = c("Matrix", "matrix"),
  delayedArray = FALSE,
  rowNamesDedup = TRUE
)
}
\arguments{
\item{OptimusDirs}{A vector of root directories of Optimus output files.
The paths should be something like this:
\code{/PATH/TO/bb4a2a5e-ff34-41b6-97d2-0c0c0c534530}.
Each entry in \code{OptimusDirs} is considered a sample and should have
its own path. Must have the same length as \code{samples}.}

\item{samples}{A vector of user-defined sample names for the sample to be
imported. Must have the same length as \code{OptimusDirs}.}

\item{matrixLocation}{Character. It is the intermediate
path to the filtered count maxtrix file saved in sparse matrix format
(\code{.npz}). Default
\code{call-MergeCountFiles/sparse_counts.npz} which works for
optimus_v1.4.0.}

\item{colIndexLocation}{Character. The intermediate path to the barcode
index file. Default \code{call-MergeCountFiles/sparse_counts_col_index.npy}.}

\item{rowIndexLocation}{Character. The intermediate path to the feature
(gene) index file. Default
\code{call-MergeCountFiles/sparse_counts_row_index.npy}.}

\item{cellMetricsLocation}{Character. It is the intermediate
path to the cell metrics file (\code{merged-cell-metrics.csv.gz}). Default
\code{call-MergeCellMetrics/merged-cell-metrics.csv.gz} which works for
optimus_v1.4.0.}

\item{geneMetricsLocation}{Character. It is the intermediate
path to the feature (gene) metrics file (\code{merged-gene-metrics.csv.gz}).
Default \code{call-MergeGeneMetrics/merged-gene-metrics.csv.gz} which works
for optimus_v1.4.0.}

\item{emptyDropsLocation}{Character. It is the intermediate
path to \link[DropletUtils]{emptyDrops} metrics file
(\code{empty_drops_result.csv}).
Default \code{call-RunEmptyDrops/empty_drops_result.csv} which works for
optimus_v1.4.0.}

\item{class}{Character. The class of the expression matrix stored in the SCE
object. Can be one of "Matrix" (as returned by
\link{readMM} function), or "matrix" (as returned by
\link[base]{matrix} function). Default "Matrix".}

\item{delayedArray}{Boolean. Whether to read the expression matrix as
\link{DelayedArray} object or not. Default \code{FALSE}.}

\item{rowNamesDedup}{Boolean. Whether to deduplicate rownames. Default 
\code{TRUE}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object
 containing the count
 matrix, the gene annotation, and the cell annotation.
}
\description{
Read the barcodes, features (genes), and matrices from Optimus
 outputs. Import them
 as one \link[SingleCellExperiment]{SingleCellExperiment} object.
}
\examples{
file.path <- system.file("extdata/Optimus_20x1000",
  package = "singleCellTK")
\dontrun{
sce <- importOptimus(OptimusDirs = file.path,
  samples = "Optimus_20x1000")
}
}
