% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBatchCorrection.R
\name{runFastMNN}
\alias{runFastMNN}
\title{Apply a fast version of the mutual nearest neighbors (MNN) batch effect
correction method to SingleCellExperiment object}
\usage{
runFastMNN(
  inSCE,
  useAssay = "logcounts",
  useReducedDim = NULL,
  batch = "batch",
  reducedDimName = "fastMNN",
  k = 20,
  propK = NULL,
  ndist = 3,
  minBatchSkip = 0,
  cosNorm = TRUE,
  nComponents = 50,
  weights = NULL,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{useAssay}{A single character indicating the name of the assay requiring
batch correction. Default \code{"logcounts"}.}

\item{useReducedDim}{A single character indicating the dimension reduction
used for batch correction. Will ignore \code{useAssay} when using.
Default \code{NULL}.}

\item{batch}{A single character indicating a field in \code{colData} that
annotates the batches of each cell; or a vector/factor with the same length
as the number of cells. Default \code{"batch"}.}

\item{reducedDimName}{A single character. The name for the corrected
low-dimensional representation. Default \code{"fastMNN"}.}

\item{k}{An integer scalar specifying the number of nearest neighbors to
consider when identifying MNNs. See "See Also". Default \code{20}.}

\item{propK}{A numeric scalar in (0, 1) specifying the proportion of cells in
each dataset to use for mutual nearest neighbor searching. See "See Also".
Default \code{NULL}.}

\item{ndist}{A numeric scalar specifying the threshold beyond which
neighbours are to be ignored when computing correction vectors. See "See
Also". Default \code{3}.}

\item{minBatchSkip}{Numeric scalar specifying the minimum relative magnitude
of the batch effect, below which no correction will be performed at a given
merge step. See "See Also". Default \code{0}.}

\item{cosNorm}{A logical scalar indicating whether cosine normalization
should be performed on \code{useAssay} prior to PCA. See "See Also". Default
\code{TRUE}.}

\item{nComponents}{An integer scalar specifying the number of dimensions to
produce. See "See Also". Default \code{50}.}

\item{weights}{The weighting scheme to use. Passed to
\code{\link[batchelor]{multiBatchPCA}}. Default \code{NULL}.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether
the SVD should be parallelized.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{reducedDim(inSCE, reducedDimName)} updated.
}
\description{
fastMNN is a variant of the classic MNN method, modified for speed and more
robust performance. For introduction of MNN, see \code{\link{runMNNCorrect}}.
}
\examples{
data('sceBatches', package = 'singleCellTK')
logcounts(sceBatches) <- log1p(counts(sceBatches))
sceCorr <- runFastMNN(sceBatches, useAssay = 'logcounts')
}
\references{
Lun ATL, et al., 2016
}
\seealso{
\code{\link[batchelor]{fastMNN}} for using \code{useAssay}, and
\code{\link[batchelor]{reducedMNN}} for using \code{useReducedDim}
}
