% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPlotting.R
\name{plotBarcodeRankScatter}
\alias{plotBarcodeRankScatter}
\title{Plots for runBarcodeRankDrops outputs.}
\usage{
plotBarcodeRankScatter(
  inSCE,
  sample = NULL,
  defaultTheme = TRUE,
  dotSize = 0.1,
  title = NULL,
  titleSize = 18,
  xlab = NULL,
  ylab = NULL,
  axisSize = 12,
  axisLabelSize = 15,
  legendSize = 10,
  combinePlot = "none",
  sampleRelHeights = 1,
  sampleRelWidths = 1
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results from
\code{\link{runBarcodeRankDrops}}. Required.}

\item{sample}{Character vector or colData variable name. Indicates which
sample each cell belongs to. Default \code{NULL}.}

\item{defaultTheme}{Removes grid in plot and sets axis title size to
\code{10} when \code{TRUE}. Default \code{TRUE}.}

\item{dotSize}{Size of dots. Default \code{0.1}.}

\item{title}{Title of plot. Default \code{NULL}.}

\item{titleSize}{Size of title of plot. Default \code{18}.}

\item{xlab}{Character vector. Label for x-axis. Default \code{NULL}.}

\item{ylab}{Character vector. Label for y-axis. Default \code{NULL}.}

\item{axisSize}{Size of x/y-axis ticks. Default \code{12}.}

\item{axisLabelSize}{Size of x/y-axis labels. Default \code{15}.}

\item{legendSize}{size of legend. Default \code{10}.}

\item{combinePlot}{Must be either \code{"all"}, \code{"sample"}, or
\code{"none"}. \code{"all"} will combine all plots into a single .ggplot
object, while \code{"sample"} will output a list of plots separated by
sample. Default \code{"all"}.}

\item{sampleRelHeights}{If there are multiple samples and combining by
\code{"all"}, the relative heights for each plot. Default \code{1}.}

\item{sampleRelWidths}{If there are multiple samples and combining by
\code{"all"}, the relative widths for each plot. Default \code{1}.}
}
\value{
a ggplot object of the scatter plot.
}
\description{
A plotting function which visualizes outputs from the
 runBarcodeRankDrops function stored in the colData slot of the SingleCellExperiment
 object via scatterplot.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- runBarcodeRankDrops(inSCE = sce)
plotBarcodeRankScatter(inSCE = sce)
}
\seealso{
\code{\link{plotBarcodeRankDropsResults}},
\code{\link{runBarcodeRankDrops}}
}
