% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{convertSeuratToSCE}
\alias{convertSeuratToSCE}
\title{convertSeuratToSCE
Converts the input seurat object to a sce object}
\usage{
convertSeuratToSCE(
  seuratObject,
  normAssayName = "seuratNormData",
  scaledAssayName = "seuratScaledData"
)
}
\arguments{
\item{seuratObject}{Input Seurat object}

\item{normAssayName}{Name of assay to store the normalized data. Default
\code{"seuratNormData"}.}

\item{scaledAssayName}{Name of assay to store the scaled data. Default
\code{"seuratScaledData"}.}
}
\value{
\code{SingleCellExperiment} output object
}
\description{
convertSeuratToSCE
Converts the input seurat object to a sce object
}
\examples{
data(scExample, package = "singleCellTK")
seurat <- convertSCEToSeurat(sce)
sce <- convertSeuratToSCE(seurat)
}
