% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{[,ontology_DAG,ANY,ANY,missing-method}
\alias{[,ontology_DAG,ANY,ANY,missing-method}
\alias{[,ontology_DAG,ANY,ANY,ANY-method}
\alias{[,ontology_DAG,ANY,missing,missing-method}
\alias{[,ontology_DAG,ANY,missing,ANY-method}
\alias{[,ontology_DAG,missing,ANY,missing-method}
\alias{[,ontology_DAG,missing,ANY,ANY-method}
\alias{[,ontology_DAG,missing,missing,missing-method}
\alias{[,ontology_DAG,missing,missing,ANY-method}
\alias{[[,ontology_DAG,character,missing-method}
\title{Create sub-DAGs}
\usage{
\S4method{[}{ontology_DAG,ANY,ANY,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{ontology_DAG,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{ontology_DAG,ANY,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{ontology_DAG,ANY,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{ontology_DAG,missing,ANY,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{ontology_DAG,missing,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{ontology_DAG,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{ontology_DAG,missing,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[[}{ontology_DAG,character,missing}(x, i, j, ...)
}
\arguments{
\item{x}{An \code{ontology_DAG} object.}

\item{i}{A single term name. The value should be a character vector. It corresponds to the roots.}

\item{j}{A single term name. The value should be a character vector. It corresponds to the leaves.}

\item{...}{Ignored.}

\item{drop}{Ignored.}
}
\value{
An \code{ontology_DAG} object.
}
\description{
Create sub-DAGs
}
\details{
It returns a sub-DAG taking node \code{i} as the root and \code{j} as the leaves. If \code{i} is a vector, a super root will be added.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
dag["b"]
dag[["b"]]
dag["b", "f"]
dag[, "f"]
}
