% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\docType{data}
\name{DiffPosMax}
\alias{DiffPosMax}
\title{DiffPosMax class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
DiffPosMax
}
\value{
The \code{DiffPosMax$new} function returns a \code{DiffPosMax} 
object which contains the information about the two profiles and the 
thresholds used to calculate the metric. It can be used, as many times 
needed, to calculate the specified metric.
}
\description{
An object which is a interface to calculate he difference 
of profiles maximal peaks positions.

The \code{DiffPosMax} object is needed to 
calculate the difference of profiles maximal peaks positions.
A threshold and the two profiles are set during the \code{DiffPosMax} 
object creation. If different thresholds or 
profiles are needed, the \code{calculateMetric} function should be used, 
with the new profiles and thresholds passed as arguments to update those
values inside the \code{DiffPosMax} object.

The threshold is the minimum peak value accepted 
to calculate the ratio.

The thresholdDiff is the maximum distance accepted 
between two maximum peaks positions in the same profile. When the 
thresholdDiff is not respected, the profile is considered having more than
one peak.

The tolerance is the maximum variation accepted on the 
maximum peak value to consider a position as a peak position. The tolerance 
must be between 0 and 1. All peaks within the tolerated range will be 
considered in the calculation of the metric.
}
\section{Constructor}{

Create a \code{DiffPosMax} object.

\code{DiffPosMax$new(profile1, profile2, threshold = 1, 
thresholdDiff = 100, tolerance = 0.01)}

The threshold is the minimum peak value accepted 
to calculate the ratio.

The thresholdDiff is the maximum distance accepted 
between two maximum peaks positions in the same profile. When the 
thresholdDiff is not respected, the profile is considered having more than
one peak.

The tolerance is the maximum variation accepted on the 
maximum peak value to consider a position as a peak position. All peaks 
within the tolerated range will be 
considered in the calculation of the metric.The tolerance must

The \code{DiffPosMax} object inherites those functions:
\itemize{
\item \code{getMetric} { A function that returns the value of the
calculated metric }
\item \code{getInfo} { A function that returns a description of the metric
with the metric value.}
\item \code{getType} { A function that returns the unique name associated
to this metric }
\item \code{calculateMetric} { A function that modifies the values of the
two profiles and the threshold. The new values (profile1, profile2, 
threshold, thresholdDiff, tolerance) are passed as arguments.}
}
}

\seealso{
\itemize{
\item \code{\link{MetricFactory}} {for using a interface to calculate all 
available metrics separately or togheter.}
}
}
\author{
Astrid Deschenes
}
\keyword{datasets}
