% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilityFunctions.R
\name{multipleSign}
\alias{multipleSign}
\title{Multiple Signatures Computation}
\usage{
multipleSign(
  dataset,
  nametype = "SYMBOL",
  inputType = "rnaseq",
  whichAssay = "norm_expr",
  whichSign = NULL,
  tumor = NULL,
  tissue = NULL,
  topic = NULL,
  ...
)
}
\arguments{
\item{dataset}{Expression values. A data frame or a matrix where rows
correspond to genes and columns correspond to samples.
Alternatively, an object of type \linkS4class{SummarizedExperiment},
\code{\link[SingleCellExperiment]{SingleCellExperiment}} or
\code{\link[SpatialExperiment]{SpatialExperiment}}.}

\item{nametype}{character string saying the type of gene name ID (row names
in dataset). Either one of "SYMBOL", "ENTREZID" or "ENSEMBL".}

\item{inputType}{character vector saying the type of data you are using.
When working with bulk data this should be either one of "microarray" or
"rnaseq". When working with single-cell data and spatial transcriptomics data
this could be "sc" to compute only signatures developed by single-cell data
or c("rnaseq", "sc") to compute all the signatures.}

\item{whichAssay}{integer scalar or string indicating which assay of
dataset to use.}

\item{whichSign}{character vector saying the signatures to compute.}

\item{tumor}{character vector saying the tumor types. Signatures from that
tumors will be computed (this can also be "pan-cancer").}

\item{tissue}{character vector saying the tumor tissues. Signatures from
that tissues will be computed (this can also be "pan-tissue").}

\item{topic}{character vector saying signatures topics. Signatures having
that topics will be computed.}

\item{...}{other arguments passed on to the signature functions.}
}
\value{
A SummarizedExperiment object in which the signatures' scores
are added in the \code{\link[SummarizedExperiment]{colData}} section.
}
\description{
This function computes all the signatures for a specific
'inputType'. Further, it is possible to select specific signatures
setting the 'tumor', the 'tissue' and/or the 'topic'.
}
\examples{
data(ovse)
multipleSign(dataset = ovse)
multipleSign(dataset = ovse, tissue = "ovary")

}
