% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{geneHeatmapSignPlot}
\alias{geneHeatmapSignPlot}
\title{Genes' Signatures' Heatmap}
\usage{
geneHeatmapSignPlot(
  data,
  nametype = "SYMBOL",
  whichSign,
  logCount = FALSE,
  whichAssay = "norm_expr",
  splitBySign = FALSE,
  sampleAnnot = NULL,
  splitBySampleAnnot = FALSE,
  ...
)
}
\arguments{
\item{data}{an object of type \linkS4class{SummarizedExperiment}. Output of
the signatures functions.}

\item{nametype}{character string saying the type of gene name ID (row names
in data). Either one of "SYMBOL", "ENTREZID" or "ENSEMBL".}

\item{whichSign}{character vector saying the signatures to plot. These must
be signatures computed with signifinder.}

\item{logCount}{logical. If TRUE it shows logarithms of expression values.}

\item{whichAssay}{integer scalar or string indicating which assay of
data to use.}

\item{splitBySign}{logical. If TRUE it splits rows by signatures.}

\item{sampleAnnot}{vector containing samples' annotations.}

\item{splitBySampleAnnot}{logical. If TRUE it splits columns by samples'
annotations.}

\item{...}{other parameters specific of the function
\code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
A \code{\link[ComplexHeatmap]{Heatmap-class}} object.
}
\description{
Given one or multiple signatures, the function returns a heatmap of the
expression values of the genes included in each of them.
}
\examples{
data(ovse)
geneHeatmapSignPlot(data = ovse, whichSign = "Ferroptosis_Ye")

}
