% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statSights.R
\name{statSights}
\alias{statSights}
\title{Statistical methods}
\usage{
statSights(statMethod, normMatrix, repIndex, normRows = NULL,
  normCols = NULL, ctrlMethod = NULL, testSide = "two.sided",
  trueMean = 0, ...)
}
\arguments{
\item{statMethod}{Statistical testing method to use either 'T' or 'RVM'.}

\item{normMatrix}{Data frame or numeric matrix of normalized data. Columns are plates, and rows are plate wells.}

\item{repIndex}{Integer vector indicating replicates in normMatrix. Which plates are replicates of each other? Provide the same number for plates belonging to a replicate group. Each index in the vector matches the corresponding column of normMatrix.}

\item{normRows, normCols}{Optional integer vector. Indicate which row/column numbers from the normMatrix should be tested. If NULL then all rows/columns from the normMatrix are used.}

\item{ctrlMethod}{Optional. FDR method to use either 'smoother' or 'bootstrap' to estimate null. Default is NULL, which does not apply FDR control to the statistical testing output.}

\item{testSide}{Optional. Type of t-test: 'two.sided', 'less', or 'greater'. Default is 'two.sided'.}

\item{trueMean}{Optional. Number indicating true value of mean. Applies to statMethod 'T'. Default is 0.}

\item{...}{Optional. Additional parameters passed to \code{\link[qvalue]{qvalue}} function.}
}
\value{
A matrix of parameters for each replicate group including p-values and q-values, if FDR control is applied.
}
\description{
Apply any of the available SIGHTS statistical methods
}
\details{
One of the two SIGHTS statistical testing methods may be chosen: \code{\link{statT}} or \code{\link{statRVM}}, and FDR control may be applied by \code{\link{statFDR}}. See their individual help pages for more details.
}
\examples{
## load dataset
data(ex_dataMatrix)

## normalize data matrix using any method and store in new variable
ex_normMatrix <- normSights(normMethod = 'RobZ', dataMatrix = ex_dataMatrix,
dataCols = 5:10, wellCorrection = TRUE)
## choose a statistical testing method, indicate FDR control
## and provide relevant information
ex_statMatrix <- statSights(normMatrix = ex_normMatrix, statMethod = 'RVM',
ctrlMethod = 'smoother', repIndex = c(1,1,1,2,2,2))

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pubmed/25190066}{Murie et al. (2015). Improving detection of rare biological events in high-throughput screens. Journal of Biomolecular Screening, 20(2), 230-241.}
}
\seealso{
Other SIGHTS functions: \code{\link{normSights}},
  \code{\link{plotSights}}
}

