% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statRVM.R
\name{statRVM}
\alias{statRVM}
\title{RVM Test}
\usage{
statRVM(normMatrix, repIndex, normRows = NULL, normCols = NULL,
  testSide = "two.sided")
}
\arguments{
\item{normMatrix}{Data frame or numeric matrix of normalized data. Columns are plates, and rows are plate wells.}

\item{repIndex}{Integer vector indicating replicates in normMatrix. Which plates are replicates of each other? Provide the same number for plates belonging to a replicate group. Each index in the vector matches the corresponding column of normMatrix.}

\item{normRows, normCols}{Optional integer vector. Indicate which row/column numbers from the normMatrix should be tested. If NULL then all rows/columns from the normMatrix are used.}

\item{testSide}{Optional. Type of t-test: 'two.sided', 'less', or 'greater'. Default is 'two.sided'.}
}
\value{
A matrix of parameters for each replicate group is returned:
\item{RVM T-statistic}{Value of the RVM t-statistic.}
\item{Mean_Difference}{Difference between the calculated and the true mean.}
\item{Standard_Error}{Standard error of the difference between means.}
\item{Degrees_Of_Freedom}{Degrees of freedom for the t-statistic.}
\item{P-value}{P-value for the RVM test.}
}
\description{
Apply one-sample RVM t-test separately to each plate
}
\details{
Random Variance Model one-sample t-test is applied to the normalized data. RVM assumes that the across replicate variances are distributed according to an inverse gamma distribution. This can be checked by using the \code{\link{plotIGFit}} function.
}
\examples{
## load dataset
data(ex_dataMatrix)

## normalize data matrix using any method and store in new variable
ex_normMatrix <- normSights(dataMatrix = ex_dataMatrix, dataCols = 5:10,
normMethod = 'normZ')
## apply RVM test to normalized data matrix and get the p-values
ex_testMatrix <- statRVM(normMatrix = ex_normMatrix, repIndex = c(1,1,1,2,2,2))

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pubmed/16465162}{Malo et al. (2006). Statistical practice in high-throughput screening data analysis. Nature Biotechnology, 24(2), 167-175.}

\href{http://www.ncbi.nlm.nih.gov/pubmed/14668230}{Wright & Simon (2003). A random variance model for detection of differential gene expression in small microarray experiments. Bioinformatics, 19(18), 2448-2455.}
}
\seealso{
Other statistical methods: \code{\link{statFDR}},
  \code{\link{statT}}
}

