% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHist.R
\name{plotHist}
\alias{plotHist}
\title{Histogram}
\usage{
plotHist(plotMatrix, plotRows = NULL, plotCols = NULL, plotAll = FALSE,
  plotSep = TRUE, plotName = NULL, colNames = NULL, ...)
}
\arguments{
\item{plotMatrix}{Data frame or numeric matrix consisting only of p-values or q-values. Columns are samples, and rows are plate wells.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotAll}{Optional logical. Should all p-values or q-values be plotted together? Default is FALSE.}

\item{plotSep}{Optional logical. If plotAll is FALSE, should plots be presented in separate windows? Default is TRUE.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}

\item{colNames}{Optional. If plotAll is FALSE, names of plotCols for plot titles.}

\item{...}{Optional. Additional parameters passed to \code{\link[ggplot2]{geom_histogram}}.}
}
\value{
Modifiable ggplot2 object or list of objects
}
\description{
Plot histogram of p-values or q-values for each plate or all plates together
}
\details{
Histograms can be used to compare actual to expected p-value distributions obtained from statistical tests of replicated features. In the presence of rare biological events, the p-value distribution should be approximately uniformly distributed with somewhat more small p-values. Deviations from these patterns indicate that the activity measurements are incorrect and/or that the statistical model is incorrectly specified.
}
\note{
If using output from \code{\link{statT}}, \code{\link{statRVM}}, \code{\link{statFDR}} or \code{\link{statSights}}, please only select the plotCols corresponding to p-value and/or q-value columns, i.e., every 5th and/or 6th column in that output. Also, the x-axis label is derived from these column names indicating either 'p-values' or 'q-values'.
}
\examples{
## load dataset
data(ex_dataMatrix)

## normalize data matrix using any method and store in new variable
ex_normMatrix <- normZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)
## apply any test to normalized data and store in new variable
ex_testMatrix <- statRVM(normMatrix = ex_normMatrix,
repIndex = c(1,1,1,2,2,2))
## plot p-value data by selecting the p-value columns from test result matrix
plotHist(plotMatrix = ex_testMatrix, plotCols = c(5,10), plotName = 'Example',
colNames = c('Set_A', 'Set_B'))

}
\seealso{
Other graphical devices: \code{\link{plot3d}},
  \code{\link{plotAutoco}}, \code{\link{plotBox}},
  \code{\link{plotHeatmap}}, \code{\link{plotIGFit}},
  \code{\link{plotScatter}}
}

