% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Heat map}
\usage{
plotHeatmap(plotMatrix, plateRows, plateCols, plotRows = NULL,
  plotCols = NULL, plotName = NULL, plotSep = TRUE, ...)
}
\arguments{
\item{plotMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{plateRows, plateCols}{Number of rows/columns in plate.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}

\item{plotSep}{Optional logical. Should plots be presented in separate windows? Default is TRUE.}

\item{...}{Optional. Additional parameters passed to \code{\link[ggplot2]{geom_tile}}.}
}
\value{
Modifiable ggplot2 object or list of objects
}
\description{
Plot heat map for each plate
}
\details{
Heat maps can be used to assess the existence of spatial bias on a plate by plate basis.  Spatial bias can be visually subtle, however, and sometimes difficult to detect with heat maps. Auto-correlation plots (\code{\link{plotAutoco}}) can circumvent this problem.
}
\examples{
## load dataset
data(ex_dataMatrix)

## plot raw data with graphs separated
plotHeatmap(plotMatrix = ex_dataMatrix, plotCols = 5:10,
plotName = 'Example', plateRows = 8, plateCols = 10)
## normalize data matrix using any method and store in new variable
ex_normMatrix <- normZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)
## plot normalized data with graphs together
plotHeatmap(plotMatrix = ex_normMatrix, plotName = 'Example',
plateRows = 8, plateCols = 10, plotSep = FALSE)

}
\seealso{
Other graphical devices: \code{\link{plot3d}},
  \code{\link{plotAutoco}}, \code{\link{plotBox}},
  \code{\link{plotHist}}, \code{\link{plotIGFit}},
  \code{\link{plotScatter}}
}

