% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normSights.R
\name{normSights}
\alias{normSights}
\title{Normalization methods}
\usage{
normSights(normMethod, dataMatrix, plateRows, plateCols, dataRows = NULL,
  dataCols = NULL, trimFactor = 0.2, wellCorrection = FALSE,
  biasMatrix = NULL, biasCols = NULL, seqFilter = TRUE)
}
\arguments{
\item{normMethod}{Normalization method name from SIGHTS ('Z', 'RobZ', 'R', 'SPAWN', 'Loess', or 'MedFil')}

\item{dataMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{plateRows, plateCols}{Number of rows/columns in plate. Applies to normMethods 'R', 'SPAWN', 'Loess', and 'MedFil'.}

\item{dataRows, dataCols}{Optional integer vector. Indicate which row/column numbers from the dataMatrix should be normalized. If NULL then all rows/columns from the dataMatrix are used.}

\item{trimFactor}{Optional trim value to be used in trimmed mean polish. It should be between 0 and 0.5. Default is 0.2. Applies to normMethod 'SPAWN'.}

\item{wellCorrection}{Optional logical. If TRUE then individual wells are corrected based on spatial bias. Applies to normMethod 'SPAWN'.}

\item{biasMatrix}{Optional data frame or numeric matrix, in the same format as dataMatrix and with the same plateRows and plateCols specifications. If NULL then normalized data is used as bias template. Applies to normMethod 'SPAWN'.}

\item{biasCols}{Optional integer vector. Indicate which column numbers from biasMatrix or normalized dataMatrix (subset of dataCols) should be used to calculate bias template. Control plates or selection of dataMatrix plates to be used for well correction. If NULL then all plates of biasMatrix or normalized dataMatrix are used. Applies to normMethod 'SPAWN'.}

\item{seqFilter}{Optional logical. If TRUE apply initial row median filter then standard filter, else just apply standard filter. Applies to normMethod 'MedFil'.}
}
\value{
Numeric matrix of normalized data in the same format as dataMatrix
}
\description{
Apply any of the available SIGHTS normalization methods
}
\details{
One of the following SIGHTS normalization methods may be chosen: \code{\link{normZ}}, \code{\link{normRobZ}}, \code{\link{normR}}, \code{\link{normSPAWN}}, \code{\link{normLoess}}, or \code{\link{normMedFil}}. See their individual help pages for more details.
}
\note{
For information on how to arrange your dataset for dataMatrix, please see (\code{\link{ex_dataMatrix}})
}
\examples{
## load dataset
data(ex_dataMatrix)

## choose a normalization method and provide relevant information
ex_normMatrix <- normSights(dataMatrix = ex_dataMatrix, dataCols = 5:10,
normMethod = 'RobZ')

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pubmed/25190066}{Murie et al. (2015). Improving detection of rare biological events in high-throughput screens. Journal of Biomolecular Screening, 20(2), 230-241.}
}
\seealso{
Other SIGHTS functions: \code{\link{plotSights}},
  \code{\link{statSights}}
}

