% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normRobZ.R
\name{normRobZ}
\alias{normRobZ}
\title{Normalization by robust Z score method}
\usage{
normRobZ(dataMatrix, dataRows = NULL, dataCols = NULL)
}
\arguments{
\item{dataMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{dataRows, dataCols}{Optional integer vector. Indicate which row/column numbers from the dataMatrix should be normalized. If NULL then all rows/columns from the dataMatrix are used.}
}
\value{
Numeric matrix of normalized data in the same format as dataMatrix
}
\description{
Apply robust Z score to data
}
\details{
Robust Z score normalization subtracts the median of the raw well intensities of a given plate from the signal intensity of a given compound and divides it by the median absolute deviation of the raw well intensities of that plate.
}
\note{
For information on how to arrange your dataset for dataMatrix, please see (\code{\link{ex_dataMatrix}})
}
\examples{
## load dataset
data(ex_dataMatrix)

## apply robust Z score
ex_normMatrix <- normRobZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pubmed/16465162}{Malo et al. (2006). Statistical practice in high-throughput screening data analysis. Nature Biotechnology, 24(2), 167-175.}
}
\seealso{
Other normalization methods: \code{\link{normLoess}},
  \code{\link{normMedFil}}, \code{\link{normR}},
  \code{\link{normSPAWN}}, \code{\link{normZ}}
}

