% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normLoess.R
\name{normLoess}
\alias{normLoess}
\title{Normalization by loess method}
\usage{
normLoess(dataMatrix, plateRows, plateCols, dataRows = NULL,
  dataCols = NULL)
}
\arguments{
\item{dataMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{plateRows, plateCols}{Number of rows/columns in plate.}

\item{dataRows, dataCols}{Optional integer vector. Indicate which row/column numbers from the dataMatrix should be normalized. If NULL then all rows/columns from the dataMatrix are used.}
}
\value{
Numeric matrix of normalized data in the same format as dataMatrix
}
\description{
Apply loess normalization to data
}
\details{
Loess normalization adjusts each well by the fitted row and column values generated by calculating the loess curve for each row and column.
}
\note{
For information on how to arrange your dataset for dataMatrix, please see (\code{\link{ex_dataMatrix}})
}
\examples{
## load dataset
data(ex_dataMatrix)

## apply Loess method
ex_normMatrix <- normLoess(dataMatrix = ex_dataMatrix, dataCols = 5:10,
plateRows = 8, plateCols = 10)

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3117325/}{Baryshnikova et al. (2010). Quantitative analysis of fitness and genetic interactions in yeast on a genome scale. Nature Methods, 7(12), 1017-1024.}
}
\seealso{
Other normalization methods: \code{\link{normMedFil}},
  \code{\link{normRobZ}}, \code{\link{normR}},
  \code{\link{normSPAWN}}, \code{\link{normZ}}
}

