% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{Parameter-class}
\alias{Parameter-class}
\alias{Parameter}
\alias{InputParameterList}
\alias{InputParameterList-class}
\alias{OutputParameterList}
\alias{OutputParameterList-class}
\alias{InputParameter-class}
\alias{InputParameter}
\alias{OutputParameter-class}
\alias{OutputParameter}
\title{Paramter class (reference class)}
\usage{
InputParameterList(...)

OutputParameterList(...)
}
\arguments{
\item{\dots}{element or list of the element.}
}
\value{
Parameter object
}
\description{
Define an input or output parameter to a process.
}
\section{Fields}{

\describe{
\item{\code{type}}{[ANY] Specify valid types of data that may be assigned
to this parameter.}

\item{\code{label}}{[character] A short, human-readable label of this
parameter object.}

\item{\code{description}}{[character] A long, human-readable description
of this parameter object.}

\item{\code{streamable}}{[logical] Currently only applies if type is
File. A value of true indicates that the file is read or written
sequentially without seeking. An implementation may use this flag
to indicate whether it is valid to stream file contents using a
named pipe. Default: false.}

\item{\code{default}}{[ANY] The default value for this parameter if not
provided in the input object.}

\item{\code{id}}{(character) The unique identifier for this parameter object.}

\item{\code{inputBinding}}{[Binding] Describes how to handle the inputs of
a process and convert them into a concrete form for execution, such
as command line parameters.}

\item{\code{id}}{(character) The unique identifier for this parameter object.}
}}


\examples{
Parameter(
  type = "integer", label = "thread",
  description = "Specify the thread #",
  default = 0
)

ipl <- InputParameterList(
  InputParameter(
    id = "BAM", type = "File",
    label = "input bam",
    description = "input bam",
    inputBinding = CommandLineBinding(
      position = 1L
    )
  ),
  InputParameter(
    id = "level", type = "Integer",
    label = "Compression level",
    description = "Compression level",
    inputBinding = CommandLineBinding(
      position = 2L,
      prefix = "-l"
    )
  )
)
ipl
}
