% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predLoops}
\alias{predLoops}
\title{Predict looping interactions.}
\usage{
predLoops(
  gi,
  formula = NULL,
  betas = NULL,
  colname = "pred",
  cutoff = get("cutoffBest10")
)
}
\arguments{
\item{gi}{A \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} object with coverage
correlation and genomic features in metadata columns. See
\link{prepareCisPairs} and \link{addCor} to build it.}

\item{formula}{A \code{\link[stats]{formula}}. All predictor variables should
be available in the in metadata columns of \code{gi}. If NULL, the following
default formula is used: \code{~ dist + strandOrientation + score_min +
chip}.}

\item{betas}{A vector with parameter estimates for predictor variables. They
should be in the same order as variables in \code{formula}. Per default
estimates of \code{\link{modelBest10Avg}} are used. See
\code{?modelBest10Avg} for more detailed information on each parameter.}

\item{colname}{A \code{character} as column name of new metadata column in
\code{gi} for predictions.}

\item{cutoff}{Numeric cutoff on prediction score. Only interactions with
interaction probability >= \code{cutoff} are reported. If \code{NULL}, all
input interactions are reported. Default is \code{\link{cutoffBest10}}, an
optimal cutoff based on F1-score on 10 best performing transcription factor
ChIP-seq data sets. See \code{?cutoffBest10} for more details.}
}
\value{
A \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} as \code{gi} with an
 additional metadata column holding the predicted looping probability.
}
\description{
This function takes a \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} object with
candidate looping interactions. It should be annotated with features in
metadata columns. A logistic regression model is applied to predict looping
interaction probabilities.
}
\examples{

# use example CTCF moitf location on human chromosome 22 with chip coverage
motifGR <- sevenC::motif.hg19.CTCF.chr22.cov

# build candidate interactions
gi <- prepareCisPairs(motifGR)

# add ChIP-seq signals correlation
gi <- addCovCor(gi)

# predict chromatin looping interactions
loops <- predLoops(gi)

# add prediction score for all candidates without filter
gi <- predLoops(gi, cutof = NULL)

# add prediction score using custom column name
gi <- predLoops(gi, cutof = NULL, colname = "my_colname")

# Filter loop predictions on custom cutoff
loops <- predLoops(gi, cutoff = 0.4)

# predict chromatin looping interactions using custom model parameters
myParams <- c(-4, -5, -2, -1, -1, 5, 3)
loops <- predLoops(gi, betas = myParams)

# predict chromatin loops using custom model formula and params
myFormula <- ~ dist + score_min
# define parameters for intercept, dist and motif_min
myParams <- c(-5, -4, 6)
loops <- predLoops(gi, formula = myFormula, betas = myParams)

}
\seealso{
\code{\link{prepareCisPairs}}, \code{\link{addCor}}
}
