% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_signal.R
\name{viewGRangesWinSummary_dt}
\alias{viewGRangesWinSummary_dt}
\title{Summarizes signal in bins.  The same number of bins per region in qgr is used
and widths can vary in qgr, in contrast to
\code{\link{viewGRangesWinSample_dt}} where width must be constant across
regions.}
\usage{
viewGRangesWinSummary_dt(
  score_gr,
  qgr,
  n_tiles = 100,
  attrib_var = "score",
  attrib_type = NULL,
  fill_value = 0,
  anchor = c("center", "center_unstranded", "left", "left_unstranded")[1],
  summary_FUN = stats::weighted.mean
)
}
\arguments{
\item{score_gr}{GRanges with a "score" metadata column.}

\item{qgr}{regions to view by window.}

\item{n_tiles}{numeric >= 1, the number of tiles to use for every region in
qgr.}

\item{attrib_var}{character name of attribute to pull data from. Default is
"score", compatible with with bigWigs or bam coverage.}

\item{attrib_type}{one of NULL, qualitative or quantitative.  If NULL will
attempt to guess by casting attrib_var attribute to character or factor.
Default is NULL.}

\item{fill_value}{numeric or character value to use where queried regions are
empty.  Default is 0 and appropriate for both calculated coverage and
bedgraph/bigwig like files.  Will automatically switch to "MISSING" if data
is guessed to be qualitative.}

\item{anchor}{character. controls how x value is derived from position for
each region in qgr.  0 may be the left side or center.  If not unstranded,
x coordinates are flipped for (-) strand. One of c("center",
"center_unstranded", "left", "left_unstranded"). Default is "center".}

\item{summary_FUN}{function. used to aggregate score by tile.  must accept
x=score and w=width numeric vectors as only arguments. default is
weighted.mean.  limma::weighted.median is a good alternative.}
}
\value{
data.table that is GRanges compatible
}
\description{
This function is most appropriate where features are expected to vary greatly
in size and feature boundaries are important, ie. gene bodies, enhancers or
TADs.
}
\details{
Columns in output data.table are: standard GRanges columns: seqnames, start,
end, width, strand id - matched to names(score_gr). if names(score_gr) is
missing, added as seq_along(score_gr). y - value of score from score_gr x -
relative bp position
}
\examples{
data(CTCF_in_10a_overlaps_gr)
bam_file = system.file("extdata/test.bam",
    package = "seqsetvis")
qgr = CTCF_in_10a_overlaps_gr[1:5]
# unlike viewGRangesWinSample_dt, width is not fixed
# qgr = GenomicRanges::resize(qgr, width = 500, fix = "center")
bam_gr = seqsetvis:::fetchBam(bam_file, qgr)
bam_dt = viewGRangesWinSummary_dt(bam_gr, qgr, 50)

if(Sys.info()['sysname'] != "Windows"){
    bw_file = system.file("extdata/MCF10A_CTCF_FE_random100.bw",
        package = "seqsetvis")
    bw_gr = rtracklayer::import.bw(bw_file, which = qgr)
    bw_dt = viewGRangesWinSummary_dt(bw_gr, qgr, 50)
}
}
