% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_signal_plots.R
\name{ssvSignalScatterplot}
\alias{ssvSignalScatterplot}
\title{maps signal from 2 sample profiles to the x and y axis. axes are standard or "volcano" min XY vs fold-change Y/X}
\usage{
ssvSignalScatterplot(
  bw_data,
  x_name,
  y_name,
  color_table = NULL,
  value_variable = "y",
  xy_variable = "sample",
  value_function = max,
  by_ = "id",
  plot_type = c("standard", "volcano")[1],
  show_help = FALSE,
  fixed_coords = TRUE,
  return_data = FALSE
)
}
\arguments{
\item{bw_data}{a GRanges or data.table of bigwig signal.
As returned from \code{\link{ssvFetchBam}} and \code{\link{ssvFetchBigwig}}}

\item{x_name}{sample name to map to x-axis, must be stored in variable specified in \code{xy_variable}}

\item{y_name}{sample name to map to y-axis, must be stored in variable specified in \code{xy_variable}}

\item{color_table}{data.frame with 2 columns, one of which must be named "group" and gets mapped to color.
The other column must be the same as by_ parameter and is used for merging.}

\item{value_variable}{variable name that stores numeric values for plotting, default is "y"}

\item{xy_variable}{variable name that stores sample, must contain entires for \code{x_name} and \code{y_name}}

\item{value_function}{a function to apply to \code{value_variable} in all combintations of \code{by_} per \code{x_name} and \code{y_name}}

\item{by_}{variables that store individual measurement ids}

\item{plot_type}{standard or volcano, default is "standard"}

\item{show_help}{if TRUE overlay labels to aid plot interpretation, default is FALSE}

\item{fixed_coords}{if TRUE coordinate system is 1:1 ratio, default is TRUE}

\item{return_data}{logical.  If TRUE, return value is no longer ggplot and
is instead the data used to generate that plot. Default is FALSE.}
}
\value{
ggplot of points comparing signal from 2 samples
}
\description{
maps signal from 2 sample profiles to the x and y axis. axes are standard or "volcano" min XY vs fold-change Y/X
}
\examples{
data(CTCF_in_10a_profiles_gr)
ssvSignalScatterplot(CTCF_in_10a_profiles_gr,
    x_name = "MCF10A_CTCF", y_name = "MCF10AT1_CTCF")
ssvSignalScatterplot(CTCF_in_10a_profiles_gr,
    x_name = "MCF10A_CTCF", y_name = "MCF10CA1_CTCF")

ssvSignalScatterplot(CTCF_in_10a_profiles_gr,
    x_name = "MCF10A_CTCF", y_name = "MCF10AT1_CTCF",
    value_function = median) + labs(title = "median FE in regions")

ssvSignalScatterplot(CTCF_in_10a_profiles_gr,
    x_name = "MCF10A_CTCF", y_name = "MCF10AT1_CTCF",
    plot_type = "volcano")

ssvSignalScatterplot(CTCF_in_10a_profiles_gr,
    x_name = "MCF10A_CTCF", y_name = "MCF10AT1_CTCF",
    plot_type = "volcano", show_help = TRUE)
}
