% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_signal_plots.R
\name{ssvSignalLineplotAgg}
\alias{ssvSignalLineplotAgg}
\title{aggregate line signals in a single line plot}
\usage{
ssvSignalLineplotAgg(
  bw_data,
  x_ = "x",
  y_ = "y",
  sample_ = "sample",
  color_ = sample_,
  group_ = sample_,
  agg_fun = mean,
  spline_n = NULL,
  return_data = FALSE
)
}
\arguments{
\item{bw_data}{a GRanges or data.table of bigwig signal.
As returned from \code{\link{ssvFetchBam}} and \code{\link{ssvFetchBigwig}}}

\item{x_}{variable name mapped to x aesthetic, x by default.}

\item{y_}{variable name mapped to y aesthetic, y by default.}

\item{sample_}{variable name, along with region_ used to group by default,}

\item{color_}{variable name mapped to color aesthetic, sample_ by default.
change group_ to override.}

\item{group_}{group aesthetic keeps lines of geom_path from mis-connecting.
Most useful if you need to supply a
variable to later facet upon. Defaults to value of sample_.}

\item{agg_fun}{the aggregation function to apply by sample_ and x_,
default is mean}

\item{spline_n}{if not NULL, applySpline will be called with n = spline_n.
default is NULL.}

\item{return_data}{logical.  If TRUE, return value is no longer ggplot and
is instead the data used to generate that plot. Default is FALSE.}
}
\value{
ggplot of signal aggregated with agg_fun() by sample.
}
\description{
aggregate line signals in a single line plot
}
\examples{
data(CTCF_in_10a_profiles_gr)
bw_gr = CTCF_in_10a_profiles_gr
ssvSignalLineplotAgg(bw_gr) +
    labs(title = "agg regions by sample.")
ssvSignalLineplotAgg(CTCF_in_10a_profiles_gr, spline_n = 10) +
    labs(title = "agg regions by sample, with spline smoothing.")
ssvSignalLineplotAgg(subset(bw_gr, bw_gr$id \%in\% seq_len(10)),
    sample_ = "id", color_ = "id") +
    labs(title = "agg samples by region id (weird)")
ssvSignalLineplotAgg(subset(bw_gr, bw_gr$id \%in\% seq_len(10)), sample_ = "id",
    color_ = "id", spline_n = 10) +
    labs(title = "agg samples by region id (weird), with spline smoothing")
}
