% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bigwig.R
\name{ssvFetchBigwig.single}
\alias{ssvFetchBigwig.single}
\title{Fetch values from a bigwig appropriate for heatmaps etc.}
\usage{
ssvFetchBigwig.single(
  bw_file,
  qgr,
  win_size = 50,
  win_method = c("sample", "summary")[1],
  summary_FUN = stats::weighted.mean,
  anchor = c("left", "left_unstranded", "center", "center_unstranded")[3],
  return_data.table = FALSE,
  force_skip_centerFix = FALSE
)
}
\arguments{
\item{bw_file}{The character vector path to bigwig files to read from.}

\item{qgr}{Set of GRanges to query.  For valid results the width of each
interval should be identical and evenly divisible by \code{win_size}.}

\item{win_size}{The window size that evenly divides widths in \code{qgr}.}

\item{win_method}{character.  one of c("sample", "summary").  Determines
if \code{\link{viewGRangesWinSample_dt}} or
\code{\link{viewGRangesWinSummary_dt}} is used to represent each region in
qgr.}

\item{summary_FUN}{function.  only relevant if win_method is "summary".
passed to \code{\link{viewGRangesWinSummary_dt}}.}

\item{anchor}{character, one of c("center", "center_unstranded",
"left", "left_unstranded")}

\item{return_data.table}{logical. If TRUE the internal data.table is
returned instead of GRanges.  Default is FALSE.}

\item{force_skip_centerFix}{boolean, if TRUE all query ranges will be
used "as is".  This is already the case by default if win_method == "summary"
but may have applications where win_method == "sample".}
}
\value{
A GRanges (or data.table if specified) containing fetched values.
}
\description{
\code{ssvFetchBigwig.single} Gets values for each region of the query
GRanges (\code{qgr}). Values correspond to the center of each window of
size \code{win_size}.  A tidy formatted data.table
object is returned suitable for plotting using ggplots.
}
\details{
if \code{qgr} contains the range chr1:1-100 and \code{win_size} is
10, values from positions chr1 5,15,25...85, and 95 will be retrieved
from \code{bw_file}
}
