% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bigwig.R
\name{ssvFetchBigwig}
\alias{ssvFetchBigwig}
\title{Iterates a character vector (ideally named) and calls
\code{ssvFetchBigwig.single} on each.  Appends grouping variable to each
resulting data.table and uses rbindlist to efficiently combine results.}
\usage{
ssvFetchBigwig(
  file_paths,
  qgr,
  unique_names = NULL,
  names_variable = "sample",
  win_size = 50,
  win_method = c("sample", "summary")[1],
  summary_FUN = stats::weighted.mean,
  fragLens = "not_used",
  anchor = c("left", "left_unstranded", "center", "center_unstranded")[3],
  return_data.table = FALSE,
  n_cores = getOption("mc.cores", 1),
  n_region_splits = 1,
  force_skip_centerFix = FALSE
)
}
\arguments{
\item{file_paths}{character vector of file_paths to load from. Alternatively,
file_paths can be a data.frame or data.table whose first column is a
character vector of paths and additial columns will be used as metadata.}

\item{qgr}{Set of GRanges to query.  For valid results the width of each
interval should be identical and evenly divisible by \code{win_size}.}

\item{unique_names}{names to use in final data.table to designate source
bigwig.}

\item{names_variable}{The column name where unique_names are stored.
Default is 'sample'}

\item{win_size}{The window size that evenly divides widths in \code{qgr}.}

\item{win_method}{character.  one of c("sample", "summary").  Determines
if \code{\link{viewGRangesWinSample_dt}} or
\code{\link{viewGRangesWinSummary_dt}} is used to represent each region in
qgr.}

\item{summary_FUN}{function.  only relevant if win_method is "summary".
passed to \code{\link{viewGRangesWinSummary_dt}}.}

\item{fragLens}{never used by ssvFetchBigwig. Ignore.}

\item{anchor}{character, one of c("center", "center_unstranded",
"left", "left_unstranded")}

\item{return_data.table}{logical. If TRUE the internal data.table is
returned instead of GRanges.  Default is FALSE.}

\item{n_cores}{integer number of cores to use.
Uses mc.cores option if not supplied.}

\item{n_region_splits}{integer number of splits to apply to qgr. The query
GRanges will be split into this many roughly equal parts for increased
parallelization. Default is 1, no split.}

\item{force_skip_centerFix}{boolean, if TRUE all query ranges will be
used "as is".  This is already the case by default if win_method == "summary"
but may have applications where win_method == "sample".}
}
\value{
A tidy formatted GRanges (or data.table if specified) containing
fetched values.
}
\description{
\code{ssvFetchBigwig} iteratively calls \code{fetchWindowedBigwig.single}.
See \code{\link{ssvFetchBigwig.single}} for more info.
}
\details{
if \code{qgr} contains the range chr1:1-100 and \code{win_size} is
10, values from positions chr1 5,15,25...85, and 95 will be
retrieved from \code{bw_file}
}
\examples{
if(Sys.info()['sysname'] != "Windows"){
library(GenomicRanges)
bw_f = system.file("extdata/test_loading.bw",
    package = "seqsetvis", mustWork = TRUE)
bw_files = c("a" = bw_f, "b" = bw_f)
qgr = GRanges("chrTest", IRanges(1, 30))
bw_gr = ssvFetchBigwig(bw_files, qgr, win_size = 10)
bw_gr2 = ssvFetchBigwig(as.list(bw_files), qgr, win_size = 10)

bw_dt = ssvFetchBigwig(bw_files, qgr, win_size = 10,
    return_data.table = TRUE)
}
}
