% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bam.R
\name{ssvFetchBam.single}
\alias{ssvFetchBam.single}
\title{fetch a windowed version of a bam file, returns GRanges}
\usage{
ssvFetchBam.single(
  bam_f,
  qgr,
  win_size = 50,
  win_method = c("sample", "summary")[1],
  summary_FUN = stats::weighted.mean,
  fragLen = NULL,
  target_strand = c("*", "+", "-", "both")[1],
  anchor = c("left", "left_unstranded", "center", "center_unstranded")[3],
  return_data.table = FALSE,
  max_dupes = Inf,
  splice_strategy = c("none", "ignore", "add", "only", "splice_count")[1],
  flip_strand = FALSE,
  return_unprocessed = FALSE,
  force_skip_centerFix = FALSE,
  ...
)
}
\arguments{
\item{bam_f}{character or BamFile to load}

\item{qgr}{GRanges regions to fetchs}

\item{win_size}{numeric >=1.  pileup grabbed every win_size bp for win_method
sample.  If win_method is summary, this is the number of windows used
(confusing, sorry).}

\item{win_method}{character.  one of c("sample", "summary").  Determines if
\code{\link{viewGRangesWinSample_dt}} or
\code{\link{viewGRangesWinSummary_dt}} is used to represent each region in
qgr.}

\item{summary_FUN}{function.  only relevant if win_method is "summary".
passed to \code{\link{viewGRangesWinSummary_dt}}.}

\item{fragLen}{numeric, NULL, or NA.  if numeric, supplied value is used. if
NULL, value is calculated with fragLen_calcStranded if NA, raw bam pileup
with no cross strand shift is returned.}

\item{target_strand}{character. if one of "+" or "-", reads are filtered
accordingly. ignored if any other value.}

\item{anchor}{character, one of c("center", "center_unstranded", "left",
"left_unstranded")}

\item{return_data.table}{logical. If TRUE the internal data.table is returned
instead of GRanges.  Default is FALSE.}

\item{max_dupes}{numeric >= 1.  duplicate reads by strandd start position
over this number are removed, Default is Inf.}

\item{splice_strategy}{character, one of c("none", "ignore", "add", "only",
"splice_count"). Default is "none" and spliced alignment are asssumed not
present. fragLen must be NA for any other value to be valid.  "ignore" will
not count spliced regions.  add" counts spliced regions along with others,
"only" will only count spliced regions and ignore others.}

\item{flip_strand}{if TRUE, strand alignment is flipped prior to fragLen
extension. Default is FALSE.}

\item{return_unprocessed}{boolean. if TRUE returns read alignment in data.table. Default is FALSE.}

\item{force_skip_centerFix}{boolean, if TRUE all query ranges will be
used "as is".  This is already the case by default if win_method == "summary"
but may have applications where win_method == "sample".}

\item{...}{passed to Rsamtools::ScanBamParam()}
}
\value{
tidy GRanges (or data.table if specified) with pileups from bam file.
pileup is calculated only every win_size bp.
}
\description{
fetch a windowed version of a bam file, returns GRanges
}
