% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fit.zinb}
\alias{fit.zinb}
\title{Internal function}
\usage{
fit.zinb(y, z, phi, pi, gamma, it.em, epsilon)
}
\arguments{
\item{y}{\strong{observations:}
numeric vector of length \code{n}}

\item{z}{\strong{class labels:}
integer vector of length \code{n},
with entries \code{0}, \code{1} and \code{NA}}

\item{phi}{dispersion parameters\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{pi}{zero-inflation parameter(s)\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{gamma}{offset\strong{:}
numeric vector of length \code{n},
or \code{NULL}}

\item{it.em}{(maximum) number of iterations in the \code{EM} algorithm\strong{:}
positive integer (defaults to \code{100})}

\item{epsilon}{convergence criterion for the \code{EM} algorithm\strong{:}
non-negative numeric (defaults to \code{1e-04})}
}
\value{
This function returns
the parameter estimates,
the posterior probabilities,
and the likelihood.
}
\description{
This function fits the semi-supervised zero-inflated
negative binomial mixture model.
It is called by \code{\link{fit.wrap}}.
}
\examples{
# data simulation
n <- 100
z <- rep(0:1,each=n/2)
gamma <- runif(n=n,min=0,max=2)
y <- rnbinom(n=n,mu=gamma*(5+2*z),size=1/0.05)
y[sample(1:n,size=0.2*n)] <- 0
z[(n/4):n] <- NA

# model fitting
fit.zinb(y,z,phi=0.05,pi=0.2,gamma=gamma,
it.em=100,epsilon=1e-04)

}
\seealso{
This is an \code{\link{internal}} function.
The user functions are \code{\link{mixtura}} and \code{\link{scrutor}}.
}
\keyword{internal}
