% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_bam_file}
\alias{read_bam_file}
\title{Read \code{bam} files}
\usage{
read_bam_file(file, features, ...)
}
\arguments{
\item{file}{A string. The path to the file.}

\item{features}{A \code{GRanges} object.}

\item{...}{Other arguments passed to \code{\link[bamsignals]{bamCount}}.}
}
\value{
A \code{matrix}
}
\description{
Count the reads in each range of the \code{GRanges} object
}
\examples{
# locate the bam file
bam_file <- system.file("extdata", "randomBam.bam", package = "bamsignals")

# load a granges object
rand_anno <- system.file("extdata",
                         "randomAnnot.Rdata",
                         package = "bamsignals")
features <- GenomicRanges::promoters(get(load(rand_anno)))

# count reads in ranges
read_bam_file(bam_file, features)

}
