% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{analyze}
\alias{analyze}
\title{Analyze single-cell data}
\usage{
analyze(
  rna.x,
  adt.x = NULL,
  crispr.x = NULL,
  block = NULL,
  rna.subsets = list(),
  adt.subsets = list(),
  suggestRnaQcThresholds.args = list(),
  suggestAdtQcThresholds.args = list(),
  suggestCrisprQcThresholds.args = list(),
  filter.cells = TRUE,
  centerSizeFactors.args = list(),
  computeClrm1Factors.args = list(),
  normalizeCounts.args = list(),
  modelGeneVariances.args = list(),
  chooseHighlyVariableGenes.args = list(),
  runPca.args = list(),
  use.rna.pcs = TRUE,
  use.adt.pcs = TRUE,
  use.crispr.pcs = TRUE,
  scaleByNeighbors.args = list(),
  correctMnn.args = list(),
  runUmap.args = list(),
  runTsne.args = list(),
  buildSnnGraph.args = list(),
  clusterGraph.args = list(),
  runAllNeighborSteps.args = list(),
  kmeans.clusters = NULL,
  clusterKmeans.args = list(),
  clusters.for.markers = c("graph", "kmeans"),
  scoreMarkers.args = list(),
  BNPARAM = AnnoyParam(),
  rna.assay = 1L,
  adt.assay = 1L,
  crispr.assay = 1L,
  num.threads = 3L
)
}
\arguments{
\item{rna.x}{Matrix-like object containing RNA counts.
This should have the same number of columns as the other \code{*.x} arguments.

Alternatively, a \link[SummarizedExperiment]{SummarizedExperiment} instance containing such a matrix in its \code{rna.assay}.

Alternatively \code{NULL}, if no RNA counts are available.}

\item{adt.x}{Matrix-like object containing ADT counts.
This should have the same number of columns as the other \code{*.x} arguments.

Alternatively, a \link[SummarizedExperiment]{SummarizedExperiment} instance containing such a matrix in its \code{adt.assay}.

Alternatively \code{NULL}, if no ADT counts are available.}

\item{crispr.x}{Matrix-like object containing ADT counts.
This should have the same number of columns as the other \code{*.x} arguments.

Alternatively, a \link[SummarizedExperiment]{SummarizedExperiment} instance containing such a matrix in its \code{crispr.assay}.

Alternatively \code{NULL}, if no ADT counts are available.}

\item{block}{Factor specifying the block of origin (e.g., batch, sample) for each cell in the \code{*_x} matrices.
Alternatively \code{NULL}, if all cells are from the same block.}

\item{rna.subsets}{Gene subsets for quality control, typically used for mitochondrial genes.
See the \code{subsets} arguments in \code{\link{computeRnaQcMetrics}} for details.}

\item{adt.subsets}{ADT subsets for quality control, typically used for IgG controls.
See the \code{subsets} arguments in \code{\link{computeAdtQcMetrics}} for details.}

\item{suggestRnaQcThresholds.args}{Named list of arguments to pass to \code{\link{suggestRnaQcThresholds}}.}

\item{suggestAdtQcThresholds.args}{Named list of arguments to pass to \code{\link{suggestAdtQcThresholds}}.}

\item{suggestCrisprQcThresholds.args}{Named list of arguments to pass to \code{\link{suggestCrisprQcThresholds}}.}

\item{filter.cells}{Logical scalar indicating whether to filter the count matrices to only retain high-quality cells in all modalities.
If \code{FALSE}, QC metrics and thresholds are still computed but are not used to filter the count matrices.}

\item{centerSizeFactors.args}{Named list of arguments to pass to \code{\link{centerSizeFactors}}.}

\item{computeClrm1Factors.args}{Named list of arguments to pass to \code{\link{computeClrm1Factors}}.
Only used if \code{adt.x} is provided.}

\item{normalizeCounts.args}{Named list of arguments to pass to \code{\link{normalizeCounts}}.}

\item{modelGeneVariances.args}{Named list of arguments to pass to \code{\link{modelGeneVariances}}.
Only used if \code{rna.x} is provided.}

\item{chooseHighlyVariableGenes.args}{Named list of arguments to pass to \code{\link{chooseHighlyVariableGenes}}.
Only used if \code{rna.x} is provided.}

\item{runPca.args}{Named list of arguments to pass to \code{\link{runPca}}.}

\item{use.rna.pcs}{Logical scalar indicating whether to use the RNA-derived PCs for downstream steps (i.e., clustering, visualization).
Only used if \code{rna.x} is provided.}

\item{use.adt.pcs}{Logical scalar indicating whether to use the ADT-derived PCs for downstream steps (i.e., clustering, visualization).
Only used if \code{adt.x} is provided.}

\item{use.crispr.pcs}{Logical scalar indicating whether to use the CRISPR-derived PCs for downstream steps (i.e., clustering, visualization).
Only used if \code{crispr.x} is provided.}

\item{scaleByNeighbors.args}{Named list of arguments to pass to \code{\link{scaleByNeighbors}}.
Only used if multiple modalities are available and their corresponding \code{use.*.pcs} arguments are \code{TRUE}.}

\item{correctMnn.args}{Named list of arguments to pass to \code{\link{correctMnn}}.
Only used if \code{block} is supplied.}

\item{runUmap.args}{Named list of arguments to pass to \code{\link{runUmap}}.
If \code{NULL}, UMAP is not performed.}

\item{runTsne.args}{Named list of arguments to pass to \code{\link{runTsne}}.
If \code{NULL}, t-SNE is not performed.}

\item{buildSnnGraph.args}{Named list of arguments to pass to \code{\link{buildSnnGraph}}.
Ignored if \code{clusterGraph.args = NULL}.}

\item{clusterGraph.args}{Named list of arguments to pass to \code{\link{clusterGraph}}.
If \code{NULL}, graph-based clustering is not performed.}

\item{runAllNeighborSteps.args}{Named list of arguments to pass to \code{\link{runAllNeighborSteps}}.}

\item{kmeans.clusters}{Integer scalar specifying the number of clusters to use in k-means clustering.
If \code{NULL}, k-means clustering is not performed.}

\item{clusterKmeans.args}{Named list of arguments to pass to \code{\link{clusterKmeans}}.
Ignored if \code{kmeans.clusters = NULL}.}

\item{clusters.for.markers}{Character vector of clustering algorithms (either \code{"graph"} or \code{"kmeans"}, specifying the clustering to be used for marker detection.
The first available clustering will be chosen.}

\item{scoreMarkers.args}{Named list of arguments to pass to \code{\link{scoreMarkers}}.
Ignored if no suitable clusterings are available.}

\item{BNPARAM}{A \link[BiocNeighbors]{BiocNeighborParam} instance specifying the nearest-neighbor search algorithm to use.}

\item{rna.assay}{Integer scalar or string specifying the assay to use if \code{rna.x} is a \link[SummarizedExperiment]{SummarizedExperiment}.}

\item{adt.assay}{Integer scalar or string specifying the assay to use if \code{adt.x} is a \link[SummarizedExperiment]{SummarizedExperiment}.}

\item{crispr.assay}{Integer scalar or string specifying the assay to use if \code{crispr.x} is a \link[SummarizedExperiment]{SummarizedExperiment}.}

\item{num.threads}{Integer scalar specifying the number of threads to use in each step.}
}
\value{
List containing the results of the entire analysis:
\describe{
\item{\code{rna.qc.metrics}:}{Results of \code{\link{computeRnaQcMetrics}}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{rna.qc.thresholds}:}{Results of \code{\link{suggestRnaQcThresholds}}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{rna.qc.filter}:}{Results of \code{\link{filterRnaQcMetrics}}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{adt.qc.metrics}:}{Results of \code{\link{computeAdtQcMetrics}}.
If ADT data is not available, this is set to \code{NULL} instead.}
\item{\code{adt.qc.thresholds}:}{Results of \code{\link{suggestAdtQcThresholds}}.
If ADT data is not available, this is set to \code{NULL} instead.}
\item{\code{adt.qc.filter}:}{Results of \code{\link{filterAdtQcMetrics}}.
If ADT data is not available, this is set to \code{NULL} instead.}
\item{\code{crispr.qc.metrics}:}{Results of \code{\link{computeCrisprQcMetrics}}.
If CRISPR data is not available, this is set to \code{NULL} instead.}
\item{\code{crispr.qc.thresholds}:}{Results of \code{\link{suggestCrisprQcThresholds}}.
If CRISPR data is not available, this is set to \code{NULL} instead.}
\item{\code{crispr.qc.filter}:}{Results of \code{\link{filterCrisprQcMetrics}}.
If CRISPR data is not available, this is set to \code{NULL} instead.}
\item{\code{combined.qc.filter}:}{Logical vector indicating which cells are of high quality and should be retained for downstream analyses.}
\item{\code{rna.filtered}:}{Matrix of RNA counts that has been filtered to only contain the high-quality cells in \code{combined.qc.filter}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{adt.filtered}:}{Matrix of ADT counts that has been filtered to only contain the high-quality cells in \code{combined.qc.filter}.
If ADT data is not available, this is set to \code{NULL} instead.}
\item{\code{crispr.filtered}:}{Matrix of CRISPR counts that has been filtered to only contain the high-quality cells in \code{combined.qc.filter}.
If CRISPR data is not available, this is set to \code{NULL} instead.}
\item{\code{rna.size.factors}:}{Size factors for the RNA count matrix, derived from the sum of counts for each cell and centered with \code{\link{centerSizeFactors}}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{rna.normalized}:}{Matrix of (log-)normalized expression values derived from RNA counts, as computed by \code{\link{normalizeCounts}} using \code{rna.size.factors}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{adt.size.factors}:}{Size factors for the ADT count matrix, computed by \code{\link{computeClrm1Factors}} and centered with \code{\link{centerSizeFactors}}.
If ADT data is not available, this is set to \code{NULL} instead.}
\item{\code{adt.normalized}:}{Matrix of (log-)normalized expression values derived from ADT counts, as computed by \code{\link{normalizeCounts}} using \code{adt.size.factors}.
If ADT data is not available, this is set to \code{NULL} instead.}
\item{\code{crispr.size.factors}:}{Size factors for the CRISPR count matrix, derived from the sum of counts for each cell and centered with \code{\link{centerSizeFactors}}.
If CRISPR data is not available, this is set to \code{NULL} instead.}
\item{\code{crispr.normalized}:}{Matrix of (log-)normalized expression values derived from CRISPR counts, as computed by \code{\link{normalizeCounts}} using \code{crispr.size.factors}.
If CRISPR data is not available, this is set to \code{NULL} instead.}
\item{\code{rna.gene.variances}:}{Results of \code{\link{modelGeneVariances}}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{rna.highly.variable.genes}:}{Results of \code{\link{chooseHighlyVariableGenes}}.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{rna.pca}:}{Results of calling \code{\link{runPca}} on \code{rna.normalized} with the \code{rna.highly.variable.genes} subset.
If RNA data is not available, this is set to \code{NULL} instead.}
\item{\code{adt.pca}:}{Results of calling \code{\link{runPca}} on \code{adt.normalized}.
If ADT data is not available, this is set to \code{NULL} instead.}
\item{\code{crispr.pca}:}{Results of calling \code{\link{runPca}} on \code{crispr.normalized}.
If CRISPR data is not available, this is set to \code{NULL} instead.}
\item{\code{combined.pca}:}{If only one modality is used for the downstream analysis, this is a string specifying the list element containing the components to be used, e.g., \code{"rna.pca"}.
If multiple modalities are to be combined for downstream analysis, this contains the results of \code{\link{scaleByNeighbors}} on the PCs of those modalities.}
\item{\code{block}:}{Vector or factor containing the blocking factor for all cells (after filtering, if \code{filter.cells = TRUE}).
This is set to \code{NULL} if no blocking factor was supplied.}
\item{\code{mnn.corrected}:}{Results of \code{\link{correctMnn}} on the PCs in or referenced by \code{combined.pca}.
If no blocking factor is supplied, this is set to \code{NULL} instead.}
\item{\code{tsne}:}{Results of \code{\link{runTsne}}.
This is \code{NULL} if t-SNE was not performed.}
\item{\code{umap}:}{Results of \code{\link{runUmap}}.
This is \code{NULL} if UMAP was not performed.}
\item{\code{snn.graph}:}{Results of \code{\link{buildSnnGraph}}.
This is \code{NULL} if graph-based clustering was not performed, or if \code{return.graph=FALSE} in \code{\link{runAllNeighborSteps}}.}
\item{\code{graph.clusters}:}{Results of \code{\link{clusterGraph}}.
This is \code{NULL} if graph-based clustering was not performed.}
\item{\code{kmeans.clusters}:}{Results of \code{\link{clusterKmeans}}.
This is \code{NULL} if k-means clustering was not performed.}
\item{\code{clusters}:}{Integer vector containing the cluster assignment for each cell (after filtering, if \code{filter.cells = TRUE}).
This may be derived from \code{graph.clusters} or \code{kmeans.clusters} depending on the choice of \code{clusters.for.markers}.
If no suitable clusterings are available, this is set to NULL.}
\item{\code{rna.markers}:}{Results of calling \code{\link{scoreMarkers}} on \code{rna.normalized}.
This is \code{NULL} if RNA data is not available or no suitable clusterings are available.}
\item{\code{adt.markers}:}{Results of calling \code{\link{scoreMarkers}} on \code{adt.normalized}.
This is \code{NULL} if ADT data is not available or no suitable clusterings are available.}
\item{\code{crispr.markers}:}{Results of calling \code{\link{scoreMarkers}} on \code{crispr.normalized}.
This is \code{NULL} if CRISPR data is not available or no suitable clusterings are available.}
}
}
\description{
Execute a simple single-cell analysis pipeline, starting from a count matrix and ending with clusters, visualizations and markers.
This also supports integration of multiple modalities and correction of batch effects.
}
\examples{
library(scRNAseq)
sce <- fetchDataset("zeisel-brain-2015", "2023-12-14", realize.assays=TRUE)
sce <- sce[,1:500] # smaller dataset for a faster runtime for R CMD check. 
res <- analyze(
    sce, 
    rna.subsets=list(mito=grep("^mt-", rownames(sce))),
    num.threads=2 # keep R CMD check happy
)
str(res)
convertAnalyzeResults(res)

}
\seealso{
\code{\link{convertAnalyzeResults}}, to convert the results into a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\author{
Aaron Lun
}
