% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{jaccardIndex}
\alias{jaccardIndex}
\title{Compute the pairwise Jaccard index}
\usage{
jaccardIndex(object, i, by = NULL)
}
\arguments{
\item{object}{An object of class \link{QFeatures}.}

\item{i}{The index of the assay in \code{object}. The assay must
contain an identification matrix, that is a matrix where an
entry is \code{TRUE} if the value is observed and \code{FALSE} is the
value is missing (see examples).}

\item{by}{A vector of length equal to the number of columns in
assay \code{i} that defines groups for which the Jaccard index
should be computed separately. If missing, the Jaccard indices
are computed for all airs of cells in the dataset.}
}
\value{
A \code{data.frame} with as many rows as pairs of cells
and the following column(s):
\itemize{
\item \code{jaccard}: the computed Jaccard index
\item \code{by}: if \code{by} is not \code{NULL}, the group of the pair of cells
for which the Jaccard index is computed.
}
}
\description{
The function computes the Jaccard index between all pairs of cells.
}
\examples{

data("scp1")

## Define the identification matrix
peps <- scp1[["peptides"]]
assay(peps) <- ifelse(is.na(assay(peps)), FALSE, TRUE)
scp1 <- addAssay(scp1, peps, "id")

## Compute Jaccard indices
jaccardIndex(scp1, "id")
## Compute Jaccard indices by sample type
jaccardIndex(scp1, "id", scp1$SampleType)


}
