% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{computeSCR}
\alias{computeSCR}
\title{Compute the sample over carrier ratio (SCR)}
\usage{
computeSCR(
  object,
  i,
  colvar,
  samplePattern,
  sampleFUN = "mean",
  carrierPattern,
  carrierFUN = sampleFUN,
  rowDataName = "SCR"
)
}
\arguments{
\item{object}{A \code{QFeatures} object.}

\item{i}{A \code{character()} or \code{integer()} indicating for which
assay(s) the SCR needs to be computed.}

\item{colvar}{A \code{character(1)} indicating the variable to take
from \code{colData(object)} that gives the sample annotation.}

\item{samplePattern}{A \code{character(1)} pattern that matches the
sample encoding in \code{colvar}.}

\item{sampleFUN}{A \code{character(1)} or \code{function} that provides the
summarization function to use (eg mean, sum, media, max, ...).
Only used when the pattern matches multiple samples. Default
is \code{mean}. Note for custom function, \code{na.rm = TRUE} is passed
to \code{sampleFUN} to ignore missing values, make sure to provide
a function that accepts this argument.}

\item{carrierPattern}{A \code{character(1)} pattern that matches the
carrier encoding in \code{colvar}. Only one match per assay is
allowed, otherwise only the first match is taken}

\item{carrierFUN}{A \code{character(1)} or \code{function} that provides the
summarization function to use (eg mean, sum, media, max, ...).
Only used when the pattern matches multiple carriers. Default
is the same function as \code{sampleFUN}. Note for custom function,
\code{na.rm = TRUE} is passed to \code{carrierFUN} to ignore missing
values, make sure to provide a function that accepts this
argument.}

\item{rowDataName}{A \code{character(1)} giving the name of the new
variable in the \code{rowData} where the computed SCR will be
stored. The name cannot already exist in any of the assay
\code{rowData}.}
}
\value{
A \code{QFeatures} object for which the \code{rowData} of the given
assay(s) is augmented with the mean SCR.
}
\description{
The function computes the ratio of the intensities of sample
channels over the intentisty of the carrier channel for each
feature. The ratios are averaged within the assay.
}
\examples{
data("scp1")
scp1 <- computeSCR(scp1, 
                   i = 1,
                   colvar = "SampleType",
                   carrierPattern = "Carrier",
                   samplePattern = "Blank|Macrophage|Monocyte",
                   sampleFUN = "mean",
                   rowDataName = "MeanSCR")
## Check results
rowData(scp1)[[1]][, "MeanSCR"]

}
