% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifSNPs.R, R/classifSNPsImputation.R
\name{classifSNPs}
\alias{classifSNPs}
\alias{classifSNPsImpute}
\title{Get similarity scores and probability}
\usage{
classifSNPs(
  genos,
  R2,
  refs,
  alleletable,
  BPPARAM = BiocParallel::SerialParam()
)

classifSNPsImpute(genos, R2, refs, BPPARAM = BiocParallel::SerialParam())
}
\arguments{
\item{genos}{Matrix with the samples genotypes. It is the result of \code{getGenotypesTable}}

\item{R2}{Vector with the R2 between the SNPs and the inversion status.}

\item{refs}{List of matrices. Each matrix has, for an SNP, the frequencies of each genotype in the
different haplotypes.}

\item{alleletable}{Data frame with the reference alleles computed with \code{getAlleleTable}.}

\item{BPPARAM}{A \code{BiocParallelParam} instance. Used to parallelize computation}
}
\value{
List with the results:
\itemize{
\item{scores: Matrix with the simmilarity scores of the individuals}
\item{numSNPs: Vector with the number of SNPs used in each computation}
}
}
\description{
This function computes the similarity scores between the sample SNPs and the haplotype's
reference.
}
\details{
classifSNPs computes, for each individual, similarity scores for
all the present haplotypes. For each SNP, we compute as many similarity scores
as haplotypes present in the reference. We have defined the similarity score as
the frequency of this genotype in the different haplotype population. To compute
the global similarity score, we have computed a mean of the scores by SNP weighted
by the R2 between the SNP and the haplotype classification.

classifSNPsImpute is a version of classifSNPs that works with posterior probabilities
of imputed genotypes.
}
